/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.xcontent.XContentDocumentMapper;

public class MergeContext {
    private final XContentDocumentMapper documentMapper;
    private final DocumentMapper.MergeFlags mergeFlags;
    private final List<String> mergeConflicts = Lists.newArrayList();

    public MergeContext(XContentDocumentMapper documentMapper, DocumentMapper.MergeFlags mergeFlags) {
        this.documentMapper = documentMapper;
        this.mergeFlags = mergeFlags;
    }

    public XContentDocumentMapper docMapper() {
        return this.documentMapper;
    }

    public DocumentMapper.MergeFlags mergeFlags() {
        return this.mergeFlags;
    }

    public void addConflict(String mergeFailure) {
        this.mergeConflicts.add(mergeFailure);
    }

    public boolean hasConflicts() {
        return !this.mergeConflicts.isEmpty();
    }

    public String[] buildConflicts() {
        return this.mergeConflicts.toArray(new String[this.mergeConflicts.size()]);
    }
}

