/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.compress.lzf.LZF;
import org.elasticsearch.common.compress.lzf.LZFDecoder;
import org.elasticsearch.common.compress.lzf.LZFEncoder;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.xcontent.AbstractFieldMapper;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;

public class SourceFieldMapper
extends AbstractFieldMapper<byte[]>
implements org.elasticsearch.index.mapper.SourceFieldMapper {
    public static final String CONTENT_TYPE = "_source";
    private final boolean enabled;
    private Boolean compress;
    private long compressThreshold;
    private final SourceFieldSelector fieldSelector;

    protected SourceFieldMapper() {
        this(CONTENT_TYPE, true, null, -1L);
    }

    protected SourceFieldMapper(String name, boolean enabled, Boolean compress, long compressThreshold) {
        super(new FieldMapper.Names(name, name, name, name), Defaults.INDEX, Defaults.STORE, Defaults.TERM_VECTOR, 1.0f, true, true, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
        this.enabled = enabled;
        this.compress = compress;
        this.compressThreshold = compressThreshold;
        this.fieldSelector = new SourceFieldSelector(this.names.indexName());
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public FieldSelector fieldSelector() {
        return this.fieldSelector;
    }

    @Override
    protected Field parseCreateField(ParseContext context) throws IOException {
        if (!this.enabled) {
            return null;
        }
        if (this.store == Field.Store.NO) {
            return null;
        }
        if (context.flyweight()) {
            return null;
        }
        byte[] data = context.source();
        if (this.compress != null && this.compress.booleanValue() && !LZF.isCompressed(data) && (this.compressThreshold == -1L || (long)data.length > this.compressThreshold)) {
            data = LZFEncoder.encode(data, data.length);
            context.source(data);
        }
        return new Field(this.names().indexName(), data);
    }

    @Override
    public byte[] value(Document document) {
        Fieldable field = document.getFieldable(this.names.indexName());
        return field == null ? null : this.value(field);
    }

    @Override
    public byte[] nativeValue(Fieldable field) {
        return field.getBinaryValue();
    }

    @Override
    public byte[] value(Fieldable field) {
        byte[] value = field.getBinaryValue();
        if (value == null) {
            return value;
        }
        if (LZF.isCompressed(value)) {
            try {
                return LZFDecoder.decode(value);
            }
            catch (IOException e) {
                throw new ElasticSearchParseException("failed to decompress source", e);
            }
        }
        return value;
    }

    @Override
    public byte[] valueFromString(String value) {
        return null;
    }

    @Override
    public String valueAsString(Fieldable field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String indexedValue(String value) {
        return value;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.enabled && this.compress == null && this.compressThreshold == -1L) {
            return builder;
        }
        builder.startObject(this.contentType());
        if (!this.enabled) {
            builder.field("enabled", this.enabled);
        }
        if (this.compress != null) {
            builder.field("compress", (Object)this.compress);
        }
        if (this.compressThreshold != -1L) {
            builder.field("compress_threshold", new ByteSizeValue(this.compressThreshold).toString());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(XContentMapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        SourceFieldMapper sourceMergeWith = (SourceFieldMapper)mergeWith;
        if (!mergeContext.mergeFlags().simulate()) {
            if (sourceMergeWith.compress != null) {
                this.compress = sourceMergeWith.compress;
            }
            if (sourceMergeWith.compressThreshold != -1L) {
                this.compressThreshold = sourceMergeWith.compressThreshold;
            }
        }
    }

    private static class SourceFieldSelector
    implements FieldSelector {
        private final String name;

        private SourceFieldSelector(String name) {
            this.name = name;
        }

        @Override
        public FieldSelectorResult accept(String fieldName) {
            if (fieldName.equals(this.name)) {
                return FieldSelectorResult.LOAD_AND_BREAK;
            }
            return FieldSelectorResult.NO_LOAD;
        }
    }

    public static class Builder
    extends XContentMapper.Builder<Builder, SourceFieldMapper> {
        private boolean enabled = true;
        private long compressThreshold = -1L;
        private Boolean compress = null;

        public Builder() {
            super(SourceFieldMapper.CONTENT_TYPE);
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder compress(boolean compress) {
            this.compress = compress;
            return this;
        }

        public Builder compressThreshold(long compressThreshold) {
            this.compressThreshold = compressThreshold;
            return this;
        }

        @Override
        public SourceFieldMapper build(XContentMapper.BuilderContext context) {
            return new SourceFieldMapper(this.name, this.enabled, this.compress, this.compressThreshold);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_source";
        public static final boolean ENABLED = true;
        public static final long COMPRESS_THRESHOLD = -1L;
        public static final Field.Index INDEX = Field.Index.NO;
        public static final Field.Store STORE = Field.Store.YES;
        public static final boolean OMIT_NORMS = true;
        public static final boolean OMIT_TERM_FREQ_AND_POSITIONS = true;
    }
}

