/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import org.elasticsearch.ElasticSearchIllegalArgumentException;

public enum IndexShardState {
    CREATED(0),
    RECOVERING(1),
    STARTED(2),
    RELOCATED(3),
    CLOSED(4);

    private final byte id;

    private IndexShardState(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public static IndexShardState fromId(byte id) throws ElasticSearchIllegalArgumentException {
        if (id == 0) {
            return CREATED;
        }
        if (id == 1) {
            return RECOVERING;
        }
        if (id == 2) {
            return STARTED;
        }
        if (id == 3) {
            return RELOCATED;
        }
        if (id == 4) {
            return CLOSED;
        }
        throw new ElasticSearchIllegalArgumentException("No mapping for id [" + id + "]");
    }
}

