/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.fs;

import java.io.File;
import java.io.IOException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.support.AbstractIndexStore;

public abstract class FsIndexStore
extends AbstractIndexStore {
    private final NodeEnvironment nodeEnv;
    private final File location;

    public FsIndexStore(Index index, @IndexSettings Settings indexSettings, IndexService indexService, NodeEnvironment nodeEnv) {
        super(index, indexSettings, indexService);
        this.nodeEnv = nodeEnv;
        this.location = nodeEnv.hasNodeFile() ? nodeEnv.indexLocation(index) : null;
    }

    @Override
    public boolean persistent() {
        return true;
    }

    @Override
    public ByteSizeValue backingStoreTotalSpace() {
        if (this.location == null) {
            return new ByteSizeValue(0L);
        }
        long totalSpace = this.location.getTotalSpace();
        if (totalSpace == 0L) {
            totalSpace = 0L;
        }
        return new ByteSizeValue(totalSpace);
    }

    @Override
    public ByteSizeValue backingStoreFreeSpace() {
        if (this.location == null) {
            return new ByteSizeValue(0L);
        }
        long usableSpace = this.location.getUsableSpace();
        if (usableSpace == 0L) {
            usableSpace = 0L;
        }
        return new ByteSizeValue(usableSpace);
    }

    @Override
    public boolean canDeleteUnallocated(ShardId shardId) {
        if (this.location == null) {
            return false;
        }
        if (this.indexService.hasShard(shardId.id())) {
            return false;
        }
        return this.shardLocation(shardId).exists();
    }

    @Override
    public void deleteUnallocated(ShardId shardId) throws IOException {
        if (this.location == null) {
            return;
        }
        if (this.indexService.hasShard(shardId.id())) {
            throw new ElasticSearchIllegalStateException(shardId + " allocated, can't be deleted");
        }
        FileSystemUtils.deleteRecursively(this.shardLocation(shardId));
    }

    public File shardLocation(ShardId shardId) {
        return this.nodeEnv.shardLocation(shardId);
    }

    public File shardIndexLocation(ShardId shardId) {
        return new File(this.shardLocation(shardId), "index");
    }

    public File shardTranslogLocation(ShardId shardId) {
        return new File(this.shardLocation(shardId), "translog");
    }
}

