/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesLifecycle;

public class InternalIndicesLifecycle
extends AbstractComponent
implements IndicesLifecycle {
    private final CopyOnWriteArrayList<IndicesLifecycle.Listener> listeners = new CopyOnWriteArrayList();

    @Inject
    public InternalIndicesLifecycle(Settings settings) {
        super(settings);
    }

    @Override
    public void addListener(IndicesLifecycle.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IndicesLifecycle.Listener listener) {
        this.listeners.remove(listener);
    }

    public void beforeIndexCreated(Index index) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            listener.beforeIndexCreated(index);
        }
    }

    public void afterIndexCreated(IndexService indexService) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            listener.afterIndexCreated(indexService);
        }
    }

    public void beforeIndexShardCreated(ShardId shardId) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            listener.beforeIndexShardCreated(shardId);
        }
    }

    public void afterIndexShardCreated(IndexShard indexShard) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            listener.afterIndexShardCreated(indexShard);
        }
    }

    public void afterIndexShardStarted(IndexShard indexShard) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            listener.afterIndexShardStarted(indexShard);
        }
    }

    public void beforeIndexClosed(IndexService indexService, boolean delete) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            listener.beforeIndexClosed(indexService, delete);
        }
    }

    public void afterIndexClosed(Index index, boolean delete) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            listener.afterIndexClosed(index, delete);
        }
    }

    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, boolean delete) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            listener.beforeIndexShardClosed(shardId, indexShard, delete);
        }
    }

    public void afterIndexShardClosed(ShardId shardId, boolean delete) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            listener.afterIndexShardClosed(shardId, delete);
        }
    }
}

