/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetBinaryParseElement;
import org.elasticsearch.search.facet.FacetCollector;
import org.elasticsearch.search.facet.FacetParseElement;
import org.elasticsearch.search.facet.InternalFacets;
import org.elasticsearch.search.facet.SearchContextFacets;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.query.QueryPhaseExecutionException;

public class FacetPhase
implements SearchPhase {
    private final FacetParseElement facetParseElement;
    private final FacetBinaryParseElement facetBinaryParseElement;

    @Inject
    public FacetPhase(FacetParseElement facetParseElement, FacetBinaryParseElement facetBinaryParseElement) {
        this.facetParseElement = facetParseElement;
        this.facetBinaryParseElement = facetBinaryParseElement;
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of("facets", this.facetParseElement, "facets_binary", this.facetBinaryParseElement, "facetsBinary", this.facetBinaryParseElement);
    }

    @Override
    public void preProcess(SearchContext context) {
    }

    @Override
    public void execute(SearchContext context) throws ElasticSearchException {
        if (context.facets() == null) {
            return;
        }
        if (context.queryResult().facets() != null) {
            return;
        }
        if (context.searcher().hasCollectors("_global_")) {
            Query query = Queries.MATCH_ALL_QUERY;
            if (context.types().length > 0) {
                query = new FilteredQuery(query, context.filterCache().cache(context.mapperService().typesFilter(context.types())));
            }
            context.searcher().processingScope("_global_");
            try {
                context.searcher().search(query, NoopCollector.NOOP_COLLECTOR);
            }
            catch (IOException e) {
                throw new QueryPhaseExecutionException(context, "Failed to execute global facets", (Throwable)e);
            }
            finally {
                context.searcher().processedScope();
            }
        }
        SearchContextFacets contextFacets = context.facets();
        ArrayList<Facet> facets = Lists.newArrayListWithCapacity(2);
        if (contextFacets.facetCollectors() != null) {
            for (FacetCollector facetCollector : contextFacets.facetCollectors()) {
                facets.add(facetCollector.facet());
            }
        }
        context.queryResult().facets(new InternalFacets(facets));
    }
}

