/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.version;

import java.util.Map;
import org.apache.lucene.index.Term;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.lucene.uid.UidField;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.SearchHitPhase;
import org.elasticsearch.search.fetch.version.VersionParseElement;
import org.elasticsearch.search.internal.SearchContext;

public class VersionSearchHitPhase
implements SearchHitPhase {
    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of("version", new VersionParseElement());
    }

    @Override
    public boolean executionNeeded(SearchContext context) {
        return context.version();
    }

    @Override
    public void execute(SearchContext context, SearchHitPhase.HitContext hitContext) throws ElasticSearchException {
        long version = UidField.loadVersion(hitContext.reader(), new Term("_uid", hitContext.doc().get("_uid")));
        if (version < 0L) {
            version = -1L;
        }
        hitContext.hit().version(version);
    }
}

