/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.net.URI;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.CreateContainerBasicOptions;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateContainerOptions;
import org.fusesource.fabric.api.CreateContainerOptionsBuilder;
import org.fusesource.fabric.boot.commands.support.ContainerCreateSupport;

@Command(name="container-create", scope="fabric", description="Creates one or more new containers", detailedDescription="classpath:containerCreate.txt")
public class ContainerCreate
extends ContainerCreateSupport {
    @Option(name="--parent", multiValued=false, required=false, description="Parent container ID")
    protected String parent;
    @Option(name="--url", multiValued=false, required=false, description="The URL of the new container. To specify the resolver policy of the new container, add the URL option ?resolver=<policy>.")
    protected String url;
    @Option(name="--proxy-uri", description="Maven proxy URL to use")
    protected URI proxyUri;
    @Argument(index=0, required=true, description="The name of the container to be created. When creating multiple containers it serves as a prefix")
    protected String name;
    @Argument(index=1, required=false, description="The number of containers that should be created")
    protected int number = 1;

    protected Object doExecute() throws Exception {
        URI uri;
        this.preCreateContainer(this.name);
        String type = null;
        if (this.url == null && this.parent != null) {
            this.url = "child://" + this.parent;
            type = "child";
        } else if (this.url != null && "child".equals(type = (uri = new URI(this.url)).getScheme())) {
            this.parent = uri.getHost();
        }
        CreateContainerBasicOptions args = CreateContainerOptionsBuilder.type(type).name(this.name).parent(this.parent).resolver(this.resolver).number(this.number).ensembleServer(this.isEnsembleServer.booleanValue()).providerUri(this.url).proxyUri(this.proxyUri != null ? this.proxyUri : this.fabricService.getMavenRepoURI()).zookeeperUrl(this.fabricService.getZookeeperUrl()).jvmOpts(this.jvmOpts);
        CreateContainerMetadata[] metadatas = this.fabricService.createContainers((CreateContainerOptions)args);
        this.displayContainers(metadatas);
        this.postCreateContainers(metadatas);
        return null;
    }

    @Override
    protected void preCreateContainer(String name) {
        super.preCreateContainer(name);
        if (this.number < 1 || this.number > 99) {
            throw new IllegalArgumentException("The number of containers must be between 1 and 99.");
        }
        if (this.url == null && this.parent == null) {
            throw new IllegalArgumentException("Either an url or a parent must be specified");
        }
    }
}

