/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.ContainerProvider;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateContainerOptions;
import org.fusesource.fabric.api.FabricException;
import org.fusesource.fabric.api.FabricRequirements;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.FabricStatus;
import org.fusesource.fabric.api.PatchService;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.internal.ContainerImpl;
import org.fusesource.fabric.internal.ProfileImpl;
import org.fusesource.fabric.internal.RequirementsJson;
import org.fusesource.fabric.internal.VersionImpl;
import org.fusesource.fabric.service.ChildContainerProvider;
import org.fusesource.fabric.service.ContainerTemplate;
import org.fusesource.fabric.service.PatchServiceImpl;
import org.fusesource.fabric.utils.Base64Encoder;
import org.fusesource.fabric.utils.ObjectUtils;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;
import org.linkedin.zookeeper.client.IZKClient;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricServiceImpl
implements FabricService {
    public static String requirementsJsonPath = "/fabric/configs/org.fusesource.fabric.requirements.json";
    private static final Logger logger = LoggerFactory.getLogger(FabricServiceImpl.class);
    private IZKClient zooKeeper;
    private Map<String, ContainerProvider> providers = new ConcurrentHashMap<String, ContainerProvider>();
    private ConfigurationAdmin configurationAdmin;
    private String profile = "default";
    private ObjectName mbeanName;
    private String userName = "admin";
    private String password = "admin";
    private String defaultRepo = "http://repo.fusesource.com/nexus/content/groups/public/";

    public FabricServiceImpl() {
        this.providers.put("child", new ChildContainerProvider(this));
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getDefaultRepo() {
        return this.defaultRepo;
    }

    public void setDefaultRepo(String defaultRepo) {
        this.defaultRepo = defaultRepo;
    }

    @Override
    public Container getCurrentContainer() {
        String name = this.getCurrentContainerName();
        return this.getContainer(name);
    }

    @Override
    public String getCurrentContainerName() {
        return System.getProperty("karaf.name");
    }

    public ObjectName getMbeanName() throws MalformedObjectNameException {
        if (this.mbeanName == null) {
            this.mbeanName = new ObjectName("org.fusesource.fabric:type=FabricService");
        }
        return this.mbeanName;
    }

    public void setMbeanName(ObjectName mbeanName) {
        this.mbeanName = mbeanName;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    @Override
    public Container[] getContainers() {
        try {
            HashMap<String, Container> containers = new HashMap<String, Container>();
            List configs = this.zooKeeper.getChildren(ZkPath.CONFIGS_CONTAINERS.getPath(new String[0]));
            for (String name : configs) {
                String parentId = this.getParentOf(name);
                if (parentId.isEmpty()) {
                    if (containers.containsKey(name)) continue;
                    ContainerImpl container = new ContainerImpl(null, name, this);
                    containers.put(name, container);
                    continue;
                }
                Container parent = (Container)containers.get(parentId);
                if (parent == null) {
                    parent = new ContainerImpl(null, parentId, this);
                    containers.put(parentId, parent);
                }
                ContainerImpl container = new ContainerImpl(parent, name, this);
                containers.put(name, container);
            }
            return containers.values().toArray(new Container[containers.size()]);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    private String getParentOf(String name) throws InterruptedException, KeeperException {
        if (this.zooKeeper != null) {
            try {
                return this.zooKeeper.getStringData(ZkPath.CONTAINER_PARENT.getPath(new String[]{name})).trim();
            }
            catch (KeeperException.NoNodeException e) {
            }
            catch (Throwable e) {
                logger.warn("Failed to find parent " + name + ". This exception will be ignored.", e);
            }
        }
        return "";
    }

    @Override
    public Container getContainer(String name) {
        if (name == null) {
            return null;
        }
        try {
            Container parent = null;
            String parentId = this.getParentOf(name);
            if (parentId != null && !parentId.isEmpty()) {
                parent = this.getContainer(parentId);
            }
            return new ContainerImpl(parent, name, this);
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    public void startContainer(Container container) {
        logger.info("Starting container {}", (Object)container.getId());
        ContainerProvider provider = this.getProvider(container);
        if (!container.isAlive()) {
            provider.start(container);
        }
    }

    public void stopContainer(Container container) {
        logger.info("Stopping container {}", (Object)container.getId());
        ContainerProvider provider = this.getProvider(container);
        if (container.isAlive()) {
            provider.stop(container);
        }
    }

    public void destroyContainer(Container container) {
        logger.info("Destroying container {}", (Object)container.getId());
        ContainerProvider provider = this.getProvider(container);
        try {
            provider.destroy(container);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.zooKeeper.deleteWithChildren(ZkPath.CONFIG_CONTAINER.getPath(new String[]{container.getId()}));
            this.zooKeeper.deleteWithChildren(ZkPath.CONTAINER.getPath(new String[]{container.getId()}));
            this.zooKeeper.deleteWithChildren(ZkPath.CONTAINER_DOMAINS.getPath(new String[]{container.getId()}));
            this.zooKeeper.deleteWithChildren(ZkPath.CONTAINER_PROVISION.getPath(new String[]{container.getId()}));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ContainerProvider getProvider(Container container) {
        String type;
        CreateContainerMetadata<?> metadata = container.getMetadata();
        String string = type = metadata != null ? metadata.getCreateOptions().getProviderType() : null;
        if (type == null) {
            throw new UnsupportedOperationException("Container " + container.getId() + " has not been created using Fabric");
        }
        ContainerProvider provider = this.getProvider(type);
        if (provider == null) {
            throw new UnsupportedOperationException("Container provider " + type + " not supported");
        }
        return provider;
    }

    public static String getParentFromURI(URI uri) {
        String parent = uri.getHost();
        if (parent == null) {
            parent = uri.getSchemeSpecificPart();
        }
        return parent;
    }

    @Override
    public CreateContainerMetadata[] createContainers(CreateContainerOptions options) {
        if (options.getZookeeperUrl() == null && !options.isEnsembleServer()) {
            options.setZookeeperUrl(this.getZookeeperUrl());
        }
        if (options.getProxyUri() == null) {
            options.setProxyUri(this.getMavenRepoURI());
        }
        try {
            ContainerProvider provider = this.getProvider(options.getProviderType());
            if (provider == null) {
                throw new FabricException("Unable to find a container provider supporting '" + options.getProviderType() + "'");
            }
            Container parent = options.getParent() != null ? this.getContainer(options.getParent()) : null;
            Set metadatas = provider.create(options);
            for (CreateContainerMetadata metadata : metadatas) {
                if (metadata.isSuccess()) {
                    if (!options.isEnsembleServer()) {
                        this.createContainerConfig(parent != null ? parent.getId() : "", metadata.getContainerName());
                        ZooKeeperUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER_METADATA.getPath(new String[]{metadata.getContainerName()}), (byte[])Base64Encoder.encode(ObjectUtils.toBytes(metadata)));
                        Map<String, String> configuration = metadata.getContainerConfguration();
                        for (Map.Entry<String, String> entry : configuration.entrySet()) {
                            String key = entry.getKey();
                            String value = entry.getValue();
                            ZooKeeperUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER_ENTRY.getPath(new String[]{metadata.getContainerName(), key}), (String)value);
                        }
                        ZooKeeperUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{metadata.getContainerName()}), (String)options.getResolver());
                    }
                    metadata.setContainer(new ContainerImpl(parent, metadata.getContainerName(), this));
                    ((ContainerImpl)metadata.getContainer()).setMetadata(metadata);
                    logger.info("The container " + metadata.getContainerName() + " has been successfully created");
                    continue;
                }
                logger.info("The creation of the container " + metadata.getContainerName() + " has failed", metadata.getFailure());
            }
            return metadatas.toArray(new CreateContainerMetadata[metadatas.size()]);
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    public ContainerProvider getProvider(String scheme) {
        return this.providers.get(scheme);
    }

    public Map<String, ContainerProvider> getProviders() {
        return Collections.unmodifiableMap(this.providers);
    }

    @Override
    public URI getMavenRepoURI() {
        URI uri = URI.create(this.defaultRepo);
        try {
            if (this.zooKeeper != null && this.zooKeeper.exists(ZkPath.MAVEN_PROXY.getPath(new String[]{"download"})) != null) {
                String mavenRepo;
                List children = this.zooKeeper.getChildren(ZkPath.MAVEN_PROXY.getPath(new String[]{"download"}));
                if (children != null && !children.isEmpty()) {
                    Collections.sort(children);
                }
                if ((mavenRepo = ZooKeeperUtils.getSubstitutedPath((IZKClient)this.zooKeeper, (String)(ZkPath.MAVEN_PROXY.getPath(new String[]{"download"}) + "/" + (String)children.get(0)))) != null && !mavenRepo.endsWith("/")) {
                    mavenRepo = mavenRepo + "/";
                }
                uri = new URI(mavenRepo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uri;
    }

    @Override
    public URI getMavenRepoUploadURI() {
        URI uri = URI.create(this.defaultRepo);
        try {
            if (this.zooKeeper != null && this.zooKeeper.exists(ZkPath.MAVEN_PROXY.getPath(new String[]{"upload"})) != null) {
                String mavenRepo;
                List children = this.zooKeeper.getChildren(ZkPath.MAVEN_PROXY.getPath(new String[]{"upload"}));
                if (children != null && !children.isEmpty()) {
                    Collections.sort(children);
                }
                if ((mavenRepo = ZooKeeperUtils.getSubstitutedPath((IZKClient)this.zooKeeper, (String)(ZkPath.MAVEN_PROXY.getPath(new String[]{"upload"}) + "/" + (String)children.get(0)))) != null && !mavenRepo.endsWith("/")) {
                    mavenRepo = mavenRepo + "/";
                }
                uri = new URI(mavenRepo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uri;
    }

    public void registerProvider(String scheme, ContainerProvider provider) {
        this.providers.put(scheme, provider);
    }

    public void registerProvider(ContainerProvider provider, Map<String, Object> properties) {
        String scheme = (String)properties.get("fabric.container.protocol");
        this.registerProvider(scheme, provider);
    }

    public void unregisterProvider(String scheme) {
        if (this.providers != null && scheme != null) {
            this.providers.remove(scheme);
        }
    }

    public void unregisterProvider(ContainerProvider provider, Map<String, Object> properties) {
        String scheme = (String)properties.get("fabric.container.protocol");
        this.unregisterProvider(scheme);
    }

    public void registerMBeanServer(MBeanServer mbeanServer) {
        try {
            ObjectName name = this.getMbeanName();
            ObjectInstance objectInstance = mbeanServer.registerMBean(this, name);
        }
        catch (Exception e) {
            logger.warn("An error occurred during mbean server registration. This exception will be ignored.", (Throwable)e);
        }
    }

    public void unregisterMBeanServer(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            try {
                mbeanServer.unregisterMBean(this.getMbeanName());
            }
            catch (Exception e) {
                logger.warn("An error occurred during mbean server un-registration. This exception will be ignored.", (Throwable)e);
            }
        }
    }

    @Override
    public String getZookeeperUrl() {
        String zooKeeperUrl = null;
        try {
            Map<String, String> zookeeperConfig;
            Map<String, Map<String, String>> configurations;
            Profile profile;
            Version defaultVersion;
            if (this.zooKeeper != null && this.zooKeeper.isConnected() && (defaultVersion = this.getDefaultVersion()) != null && (profile = this.getProfile(defaultVersion.getName(), "default")) != null && (configurations = profile.getConfigurations()) != null && (zookeeperConfig = configurations.get("org.fusesource.fabric.zookeeper")) != null) {
                zooKeeperUrl = ZooKeeperUtils.getSubstitutedData((IZKClient)this.zooKeeper, (String)zookeeperConfig.get("zookeeper.url"));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (zooKeeperUrl == null) {
            try {
                Configuration config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper", null);
                zooKeeperUrl = (String)config.getProperties().get("zookeeper.url");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return zooKeeperUrl;
    }

    private void createContainerConfig(String parent, String name) {
        try {
            String configVersion = this.getDefaultVersion().getName();
            ZooKeeperUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{name}), (String)configVersion);
            ZooKeeperUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{configVersion, name}), (String)this.profile);
            this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_PARENT.getPath(new String[]{name}), parent, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Version getDefaultVersion() {
        try {
            String version = null;
            if (this.zooKeeper.exists(ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0])) != null) {
                version = this.zooKeeper.getStringData(ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]));
            }
            if (version == null || version.isEmpty()) {
                version = "1.0";
                ZooKeeperUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]), (String)version);
                ZooKeeperUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_VERSION.getPath(new String[]{version}), (String)null);
            }
            return new VersionImpl(version, this);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public void setDefaultVersion(Version version) {
        try {
            ZooKeeperUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]), (String)version.getName());
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Version createVersion(String version) {
        try {
            this.zooKeeper.createWithParents(ZkPath.CONFIG_VERSION.getPath(new String[]{version}), null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.zooKeeper.createWithParents(ZkPath.CONFIG_VERSIONS_PROFILES.getPath(new String[]{version}), null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            return new VersionImpl(version, this);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Version createVersion(Version parent, String toVersion) {
        try {
            ZooKeeperUtils.copy((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_VERSION.getPath(new String[]{parent.getName()}), (String)ZkPath.CONFIG_VERSION.getPath(new String[]{toVersion}));
            return new VersionImpl(toVersion, this);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    public void deleteVersion(String version) {
        try {
            this.zooKeeper.deleteWithChildren(ZkPath.CONFIG_VERSION.getPath(new String[]{version}));
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Version[] getVersions() {
        try {
            ArrayList<VersionImpl> versions = new ArrayList<VersionImpl>();
            List children = this.zooKeeper.getChildren(ZkPath.CONFIG_VERSIONS.getPath(new String[0]));
            for (String child : children) {
                versions.add(new VersionImpl(child, this));
            }
            Collections.sort(versions);
            return versions.toArray(new Version[versions.size()]);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Version getVersion(String name) {
        try {
            if (this.zooKeeper != null && this.zooKeeper.isConnected() && this.zooKeeper.exists(ZkPath.CONFIG_VERSION.getPath(new String[]{name})) == null) {
                throw new FabricException("Version '" + name + "' does not exist!");
            }
            return new VersionImpl(name, this);
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Profile[] getProfiles(String version) {
        try {
            List names = this.zooKeeper.getChildren(ZkPath.CONFIG_VERSIONS_PROFILES.getPath(new String[]{version}));
            ArrayList<ProfileImpl> profiles = new ArrayList<ProfileImpl>();
            for (String name : names) {
                profiles.add(new ProfileImpl(name, version, this));
            }
            return profiles.toArray(new Profile[profiles.size()]);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Profile getProfile(String version, String name) {
        try {
            String path = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{version, name});
            if (this.zooKeeper.exists(path) == null) {
                return null;
            }
            return new ProfileImpl(name, version, this);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Profile createProfile(String version, String name) {
        try {
            ZooKeeperUtils.create((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{version, name}));
            return new ProfileImpl(name, version, this);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public void deleteProfile(Profile profile) {
        try {
            this.zooKeeper.deleteWithChildren(ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{profile.getVersion(), profile.getId()}));
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    protected ContainerTemplate getContainerTemplate(Container container) {
        boolean cacheJmx = false;
        return new ContainerTemplate(container, cacheJmx, this.userName, this.password);
    }

    @Override
    public void setRequirements(FabricRequirements requirements) throws IOException {
        try {
            requirements.removeEmptyRequirements();
            String json = RequirementsJson.toJSON(requirements);
            this.zooKeeper.createOrSetWithParents(requirementsJsonPath, json, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public FabricRequirements getRequirements() {
        try {
            FabricRequirements answer = null;
            if (this.zooKeeper.exists(requirementsJsonPath) != null) {
                String json = this.zooKeeper.getStringData(requirementsJsonPath);
                answer = RequirementsJson.fromJSON(json);
            }
            if (answer == null) {
                answer = new FabricRequirements();
            }
            return answer;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public FabricStatus getFabricStatus() {
        return new FabricStatus(this);
    }

    @Override
    public PatchService getPatchService() {
        return new PatchServiceImpl(this, this.configurationAdmin);
    }
}

