/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab;

import org.fusesource.fabric.fab.util.Objects;
import org.fusesource.fabric.fab.util.Strings;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;

public class DependencyId
implements Comparable<DependencyId> {
    private final String groupId;
    private final String artifactId;
    private final String classifier;
    private final String extension;
    private final int hashCode;

    public static DependencyId newInstance(DependencyNode node) {
        return DependencyId.newInstance(node.getDependency());
    }

    public static DependencyId newInstance(Dependency dependency) {
        return DependencyId.newInstance(dependency.getArtifact());
    }

    public static DependencyId newInstance(Artifact artifact) {
        return new DependencyId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension());
    }

    public DependencyId(String groupId, String artifactId) {
        this(groupId, artifactId, "");
    }

    public DependencyId(String groupId, String artifactId, String classifier) {
        this(groupId, artifactId, classifier, "jar");
    }

    public DependencyId(String groupId, String artifactId, String classifier, String extension) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier;
        this.extension = extension;
        this.hashCode = Objects.hashCode(groupId, artifactId, classifier, extension);
    }

    public String toString() {
        return "DependencyId(" + this.groupId + ":" + this.artifactId + (Strings.notEmpty(this.classifier) ? ":" + this.classifier : "") + (Strings.notEmpty(this.extension) ? ":" + this.extension : "") + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DependencyId) {
            DependencyId that = (DependencyId)o;
            return this.hashCode() == that.hashCode() && Objects.equal(this.groupId, that.groupId) && Objects.equal(this.artifactId, that.artifactId) && Objects.equal(this.classifier, that.classifier) && Objects.equal(this.extension, that.extension);
        }
        return false;
    }

    @Override
    public int compareTo(DependencyId that) {
        int answer = Objects.compare((Comparable)((Object)this.groupId), (Comparable)((Object)that.groupId));
        if (answer == 0) {
            answer = Objects.compare((Comparable)((Object)this.artifactId), (Comparable)((Object)that.artifactId));
        }
        if (answer == 0) {
            answer = Objects.compare((Comparable)((Object)this.classifier), (Comparable)((Object)that.classifier));
        }
        if (answer == 0) {
            answer = Objects.compare((Comparable)((Object)this.extension), (Comparable)((Object)that.extension));
        }
        return answer;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }
}

