/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.maven.impl;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.fusesource.fabric.maven.impl.MavenDownloadProxyServlet;
import org.fusesource.fabric.maven.impl.MavenUploadProxyServlet;
import org.fusesource.fabric.maven.impl.SecureHttpContext;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProxyRegistrationHandler
implements LifecycleListener,
ConfigurationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenProxyRegistrationHandler.class);
    private String port;
    private final Map<String, Set<String>> registeredProxies = new HashMap<String, Set<String>>();
    private IZKClient zookeeper = null;
    private String name = System.getProperty("karaf.name");
    private HttpService httpService;
    private SecureHttpContext secureHttpContext;
    private MavenDownloadProxyServlet mavenDownloadProxyServlet;
    private MavenUploadProxyServlet mavenUploadProxyServlet;
    private ConfigurationAdmin configurationAdmin;

    public MavenProxyRegistrationHandler() {
        this.registeredProxies.put("download", new HashSet());
        this.registeredProxies.put("upload", new HashSet());
    }

    public void init() throws ServletException, NamespaceException {
        this.port = this.getPortFromConfig();
        try {
            this.httpService.registerServlet("/maven/download", (Servlet)this.mavenDownloadProxyServlet, null, null);
            this.httpService.registerServlet("/maven/upload", (Servlet)this.mavenUploadProxyServlet, null, (HttpContext)this.secureHttpContext);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to register fabric maven proxy servlets, due to:" + t.getMessage());
        }
    }

    public void destroy() {
        this.unregister("download");
        this.unregister("upload");
        try {
            this.httpService.unregister("/maven/download");
            this.httpService.unregister("/maven/upload");
        }
        catch (Exception ex) {
            LOGGER.warn("Http service returned error on servlet unregister. Possibly the service has already been stopped");
        }
    }

    public void onConnected() {
        this.register("download");
        this.register("upload");
    }

    public void onDisconnected() {
        this.unregister("download");
        this.unregister("upload");
    }

    public void register(String type) {
        this.unregister(type);
        String mavenProxyUrl = "http://${zk:" + this.name + "/ip}:" + this.getPortSafe() + "/maven/" + type + "/";
        String parentPath = ZkPath.MAVEN_PROXY.getPath(new String[]{type});
        String path = parentPath + "/p_";
        try {
            if (this.zookeeper.isConnected()) {
                if (this.zookeeper.exists(parentPath) == null) {
                    this.zookeeper.createWithParents(parentPath, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                if (this.zookeeper.exists(path) == null) {
                    this.registeredProxies.get(type).add(this.zookeeper.create(path, mavenProxyUrl.getBytes("UTF-8"), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL));
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to register maven proxy.");
        }
    }

    public void unregister(String type) {
        Set<String> proxyNodes = this.registeredProxies.get(type);
        if (proxyNodes != null) {
            try {
                for (String entry : this.registeredProxies.get(type)) {
                    if (!this.zookeeper.isConnected() || this.zookeeper.exists(entry) == null) continue;
                    this.zookeeper.deleteWithChildren(entry);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to remove maven proxy from registry.");
            }
            this.registeredProxies.get(type).clear();
        }
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (event.getPid().equals("org.ops4j.pax.web") && event.getType() == 1) {
            this.port = this.getPortFromConfig();
            this.register("download");
            this.register("upload");
        }
    }

    public String getPortFromConfig() {
        String port = "8181";
        try {
            Configuration configuration;
            Dictionary properties;
            Configuration[] configurations = this.configurationAdmin.listConfigurations("(service.pid=org.ops4j.pax.web)");
            if (configurations != null && configurations.length > 0 && (properties = (configuration = configurations[0]).getProperties()) != null && properties.get("org.osgi.service.http.port") != null) {
                port = String.valueOf(properties.get("org.osgi.service.http.port"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port;
    }

    private int getPortSafe() {
        int port = 8181;
        try {
            port = Integer.parseInt(this.getPort());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return port;
    }

    public IZKClient getZookeeper() {
        return this.zookeeper;
    }

    public void setZookeeper(IZKClient zookeeper) {
        this.zookeeper = zookeeper;
    }

    public String getPort() {
        return this.port;
    }

    public HttpService getHttpService() {
        return this.httpService;
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public MavenDownloadProxyServlet getMavenDownloadProxyServlet() {
        return this.mavenDownloadProxyServlet;
    }

    public void setMavenDownloadProxyServlet(MavenDownloadProxyServlet mavenDownloadProxyServlet) {
        this.mavenDownloadProxyServlet = mavenDownloadProxyServlet;
    }

    public MavenUploadProxyServlet getMavenUploadProxyServlet() {
        return this.mavenUploadProxyServlet;
    }

    public void setMavenUploadProxyServlet(MavenUploadProxyServlet mavenUploadProxyServlet) {
        this.mavenUploadProxyServlet = mavenUploadProxyServlet;
    }

    public SecureHttpContext getSecureHttpContext() {
        return this.secureHttpContext;
    }

    public void setSecureHttpContext(SecureHttpContext secureHttpContext) {
        this.secureHttpContext = secureHttpContext;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }
}

