/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction;

import java.io.File;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Properties;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import org.apache.aries.transaction.GeronimoPlatformTransactionManager;
import org.apache.geronimo.transaction.log.HOWLLog;
import org.apache.geronimo.transaction.log.UnrecoverableLog;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.apache.geronimo.transaction.manager.XidFactoryImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;

public class TransactionManagerService {
    public static final String TRANSACTION_TIMEOUT = "aries.transaction.timeout";
    public static final String RECOVERABLE = "aries.transaction.recoverable";
    public static final String HOWL_BUFFER_CLASS_NAME = "aries.transaction.howl.bufferClassName";
    public static final String HOWL_BUFFER_SIZE = "aries.transaction.howl.bufferSize";
    public static final String HOWL_CHECKSUM_ENABLED = "aries.transaction.howl.checksumEnabled";
    public static final String HOWL_ADLER32_CHECKSUM = "aries.transaction.howl.adler32Checksum";
    public static final String HOWL_FLUSH_SLEEP_TIME = "aries.transaction.howl.flushSleepTime";
    public static final String HOWL_LOG_FILE_EXT = "aries.transaction.howl.logFileExt";
    public static final String HOWL_LOG_FILE_NAME = "aries.transaction.howl.logFileName";
    public static final String HOWL_MAX_BLOCKS_PER_FILE = "aries.transaction.howl.maxBlocksPerFile";
    public static final String HOWL_MAX_LOG_FILES = "aries.transaction.howl.maxLogFiles";
    public static final String HOWL_MAX_BUFFERS = "aries.transaction.howl.maxBuffers";
    public static final String HOWL_MIN_BUFFERS = "aries.transaction.howl.minBuffers";
    public static final String HOWL_THREADS_WAITING_FORCE_THRESHOLD = "aries.transaction.howl.threadsWaitingForceThreshold";
    public static final String HOWL_LOG_FILE_DIR = "aries.transaction.howl.logFileDir";
    public static final int DEFAULT_TRANSACTION_TIMEOUT = 600;
    public static final boolean DEFAULT_RECOVERABLE = false;
    private static final String PLATFORM_TRANSACTION_MANAGER_CLASS = "org.springframework.transaction.PlatformTransactionManager";
    private final String pid;
    private final Dictionary properties;
    private final BundleContext bundleContext;
    private boolean useSpring;
    private GeronimoTransactionManager transactionManager;
    private TransactionLog transactionLog;
    private ServiceRegistration serviceRegistration;

    public TransactionManagerService(String pid, Dictionary properties, BundleContext bundleContext) throws ConfigurationException {
        this.pid = pid;
        this.properties = properties;
        this.bundleContext = bundleContext;
        int transactionTimeout = this.getInt(TRANSACTION_TIMEOUT, 600);
        if (transactionTimeout <= 0) {
            throw new ConfigurationException(TRANSACTION_TIMEOUT, "Property aries.transaction.timeout must be > 0");
        }
        XidFactoryImpl xidFactory = new XidFactoryImpl(pid.substring(0, Math.min(pid.length(), 64)).getBytes());
        if (this.getBool(RECOVERABLE, false)) {
            String bufferClassName = this.getString(HOWL_BUFFER_CLASS_NAME, "org.objectweb.howl.log.BlockLogBuffer");
            int bufferSizeKBytes = this.getInt(HOWL_BUFFER_SIZE, 32);
            if (bufferSizeKBytes < 1 || bufferSizeKBytes > 32) {
                throw new ConfigurationException(HOWL_BUFFER_SIZE, "bufferSize must be between 1 and 32");
            }
            boolean checksumEnabled = this.getBool(HOWL_CHECKSUM_ENABLED, true);
            boolean adler32Checksum = this.getBool(HOWL_ADLER32_CHECKSUM, true);
            int flushSleepTimeMilliseconds = this.getInt(HOWL_FLUSH_SLEEP_TIME, 50);
            String logFileExt = this.getString(HOWL_LOG_FILE_EXT, "log");
            String logFileName = this.getString(HOWL_LOG_FILE_NAME, "transaction");
            int maxBlocksPerFile = this.getInt(HOWL_MAX_BLOCKS_PER_FILE, -1);
            int maxLogFiles = this.getInt(HOWL_MAX_LOG_FILES, 2);
            int minBuffers = this.getInt(HOWL_MIN_BUFFERS, 4);
            if (minBuffers < 0) {
                throw new ConfigurationException(HOWL_MIN_BUFFERS, "minBuffers must be > 0");
            }
            int maxBuffers = this.getInt(HOWL_MAX_BUFFERS, 0);
            if (maxBuffers > 0 && minBuffers < maxBuffers) {
                throw new ConfigurationException(HOWL_MAX_BUFFERS, "minBuffers must be <= maxBuffers");
            }
            int threadsWaitingForceThreshold = this.getInt(HOWL_THREADS_WAITING_FORCE_THRESHOLD, -1);
            String logFileDir = this.getString(HOWL_LOG_FILE_DIR, null);
            if (logFileDir == null || logFileDir.length() == 0 || !new File(logFileDir).isAbsolute()) {
                throw new ConfigurationException(HOWL_LOG_FILE_DIR, "Property should be set to an absolute directory");
            }
            try {
                this.transactionLog = new HOWLLog(bufferClassName, bufferSizeKBytes, checksumEnabled, adler32Checksum, flushSleepTimeMilliseconds, logFileDir, logFileExt, logFileName, maxBlocksPerFile, maxBuffers, maxLogFiles, minBuffers, threadsWaitingForceThreshold, xidFactory != null ? xidFactory : new XidFactoryImpl(), null);
                ((HOWLLog)this.transactionLog).doStart();
            }
            catch (Exception e) {
                throw new ConfigurationException(null, null, (Throwable)e);
            }
        } else {
            this.transactionLog = new UnrecoverableLog();
        }
        try {
            try {
                this.transactionManager = new SpringTransactionManagerCreator().create(transactionTimeout, xidFactory, this.transactionLog);
                this.useSpring = true;
            }
            catch (NoClassDefFoundError e) {
                this.transactionManager = new GeronimoTransactionManager(transactionTimeout, xidFactory, this.transactionLog);
            }
        }
        catch (XAException e) {
            throw new RuntimeException("Error recovering transaction log", e);
        }
    }

    public void start() throws Exception {
        ArrayList<String> clazzes = new ArrayList<String>();
        clazzes.add(TransactionManager.class.getName());
        clazzes.add(TransactionSynchronizationRegistry.class.getName());
        clazzes.add(UserTransaction.class.getName());
        clazzes.add(RecoverableTransactionManager.class.getName());
        if (this.useSpring) {
            clazzes.add(PLATFORM_TRANSACTION_MANAGER_CLASS);
        }
        this.serviceRegistration = this.bundleContext.registerService(clazzes.toArray(new String[clazzes.size()]), (Object)this.transactionManager, (Dictionary)new Properties());
    }

    public void close() throws Exception {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
        if (this.transactionLog instanceof HOWLLog) {
            ((HOWLLog)this.transactionLog).doStop();
        }
    }

    private String getString(String property, String dflt) throws ConfigurationException {
        String value = (String)this.properties.get(property);
        if (value != null) {
            return value;
        }
        return dflt;
    }

    private int getInt(String property, int dflt) throws ConfigurationException {
        String value = (String)this.properties.get(property);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new ConfigurationException(property, "Error parsing " + property + "(" + value + ") property as an integer", (Throwable)e);
            }
        }
        return dflt;
    }

    private boolean getBool(String property, boolean dflt) throws ConfigurationException {
        String value = (String)this.properties.get(property);
        if (value != null) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                throw new ConfigurationException(property, "Error parsing " + property + "(" + value + ") property as a boolean", (Throwable)e);
            }
        }
        return dflt;
    }

    public static class SpringTransactionManagerCreator {
        public GeronimoTransactionManager create(int defaultTransactionTimeoutSeconds, XidFactory xidFactory, TransactionLog transactionLog) throws XAException {
            return new GeronimoPlatformTransactionManager(defaultTransactionTimeoutSeconds, xidFactory, transactionLog);
        }
    }
}

