/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.api;

import java.io.File;
import org.fusesource.fabric.api.CreateContainerBasicOptions;

public class CreateSshContainerOptions
extends CreateContainerBasicOptions<CreateSshContainerOptions> {
    private static final long serialVersionUID = -1171578973712670970L;
    public static final String DEFAULT_PRIVATE_KEY_FILE = System.getProperty("user.home") + File.separatorChar + ".ssh" + File.separatorChar + "id_rsa";
    static final Integer DEFAULT_SSH_RETRIES = 1;
    static final Integer DEFAULT_SSH_PORT = 22;
    private String username;
    private String password;
    private String host;
    private Integer port = DEFAULT_SSH_PORT;
    private String path = "/usr/local/fusesource/container";
    private Integer sshRetries = DEFAULT_SSH_RETRIES;
    private Integer retryDelay = 1;
    private String privateKeyFile = DEFAULT_PRIVATE_KEY_FILE;
    private String passPhrase;

    public CreateSshContainerOptions() {
        this.providerType = "ssh";
    }

    public String toString() {
        return "createSshContainer(" + this.getUsername() + "@" + this.getHost() + ":" + this.getPort() + " " + this.getPath() + ")";
    }

    public CreateSshContainerOptions username(String username) {
        this.username = username;
        return this;
    }

    public CreateSshContainerOptions password(String password) {
        this.password = password;
        return this;
    }

    public CreateSshContainerOptions host(String host) {
        this.host = host;
        return this;
    }

    public CreateSshContainerOptions port(Integer port) {
        this.port = port;
        return this;
    }

    public CreateSshContainerOptions path(String path) {
        this.path = path;
        return this;
    }

    public CreateSshContainerOptions sshRetries(Integer sshRetries) {
        this.sshRetries = sshRetries;
        return this;
    }

    public CreateSshContainerOptions retryDelay(Integer retryDelay) {
        this.retryDelay = retryDelay;
        return this;
    }

    public CreateSshContainerOptions privateKeyFile(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
        return this;
    }

    public CreateSshContainerOptions passPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
        return this;
    }

    public String getUsername() {
        try {
            return this.username != null && !this.username.isEmpty() ? this.username : this.getProviderURI().getUserInfo().split(":")[0];
        }
        catch (Exception ex) {
            throw new IllegalStateException("Username should be part of the url or explicitly specified");
        }
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        if (this.password != null && !this.password.isEmpty()) {
            return this.password;
        }
        if (this.getProviderURI() != null && this.getProviderURI().getUserInfo() != null && this.getProviderURI().getUserInfo().contains(":")) {
            return this.getProviderURI().getUserInfo().split(":")[1];
        }
        return null;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHost() {
        return this.host != null && !this.host.isEmpty() ? this.host : this.getProviderURI().getHost();
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port != null && this.port != 0 ? this.port : (this.getProviderURI() != null && this.getProviderURI().getPort() != 0 ? this.getProviderURI().getPort() : DEFAULT_SSH_PORT.intValue());
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getSshRetries() {
        return this.sshRetries != null ? this.sshRetries : DEFAULT_SSH_RETRIES;
    }

    public void setSshRetries(Integer sshRetries) {
        this.sshRetries = sshRetries;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Integer getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(Integer retryDelay) {
        this.retryDelay = retryDelay;
    }

    public String getPrivateKeyFile() {
        return this.getParameters().get("privateKeyFile") != null ? this.getParameters().get("privateKeyFile") : this.privateKeyFile;
    }

    public void setPrivateKeyFile(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
    }
}

