/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.ping.replication;

import org.elasticsearch.action.admin.cluster.ping.replication.ShardReplicationPingRequest;
import org.elasticsearch.action.admin.cluster.ping.replication.ShardReplicationPingResponse;
import org.elasticsearch.action.support.replication.TransportShardReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportShardReplicationPingAction
extends TransportShardReplicationOperationAction<ShardReplicationPingRequest, ShardReplicationPingResponse> {
    @Inject
    public TransportShardReplicationPingAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction) {
        super(settings, transportService, clusterService, indicesService, threadPool, shardStateAction);
    }

    @Override
    protected String executor() {
        return "cached";
    }

    @Override
    protected boolean checkWriteConsistency() {
        return true;
    }

    @Override
    protected ShardReplicationPingRequest newRequestInstance() {
        return new ShardReplicationPingRequest();
    }

    @Override
    protected ShardReplicationPingResponse newResponseInstance() {
        return new ShardReplicationPingResponse();
    }

    @Override
    protected String transportAction() {
        return "ping/replication/shard";
    }

    @Override
    protected TransportShardReplicationOperationAction.PrimaryResponse<ShardReplicationPingResponse> shardOperationOnPrimary(ClusterState clusterState, TransportShardReplicationOperationAction.ShardOperationRequest shardRequest) {
        return new TransportShardReplicationOperationAction.PrimaryResponse<ShardReplicationPingResponse>(new ShardReplicationPingResponse(), null);
    }

    @Override
    protected void shardOperationOnReplica(TransportShardReplicationOperationAction.ShardOperationRequest shardRequest) {
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, ShardReplicationPingRequest request) {
        return this.clusterService.state().routingTable().index(request.index()).shard(request.shardId()).shardsIt();
    }
}

