/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNodes;

public class ClusterChangedEvent {
    private final String source;
    private final ClusterState previousState;
    private final ClusterState state;
    private final DiscoveryNodes.Delta nodesDelta;

    public ClusterChangedEvent(String source, ClusterState state, ClusterState previousState) {
        this.source = source;
        this.state = state;
        this.previousState = previousState;
        this.nodesDelta = state.nodes().delta(previousState.nodes());
    }

    public String source() {
        return this.source;
    }

    public ClusterState state() {
        return this.state;
    }

    public ClusterState previousState() {
        return this.previousState;
    }

    public boolean routingTableChanged() {
        return this.state.routingTable() != this.previousState.routingTable();
    }

    public boolean indexRoutingTableChanged(String index) {
        if (!this.state.routingTable().hasIndex(index) && !this.previousState.routingTable().hasIndex(index)) {
            return false;
        }
        if (this.state.routingTable().hasIndex(index) && this.previousState.routingTable().hasIndex(index)) {
            return this.state.routingTable().index(index) != this.previousState.routingTable().index(index);
        }
        return true;
    }

    public boolean metaDataChanged() {
        return this.state.metaData() != this.previousState.metaData();
    }

    public boolean blocksChanged() {
        return this.state.blocks() != this.previousState.blocks();
    }

    public boolean localNodeMaster() {
        return this.state.nodes().localNodeMaster();
    }

    public DiscoveryNodes.Delta nodesDelta() {
        return this.nodesDelta;
    }

    public boolean nodesRemoved() {
        return this.nodesDelta.removed();
    }

    public boolean nodesAdded() {
        return this.nodesDelta.added();
    }

    public boolean nodesChanged() {
        return this.nodesRemoved() || this.nodesAdded();
    }
}

