/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.codec.binary;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.common.codec.binary.Base64;

public class Base64InputStream
extends FilterInputStream {
    private final boolean doEncode;
    private final Base64 base64;
    private final byte[] singleByte = new byte[1];

    public Base64InputStream(InputStream in) {
        this(in, false);
    }

    public Base64InputStream(InputStream in, boolean doEncode) {
        super(in);
        this.doEncode = doEncode;
        this.base64 = new Base64();
    }

    public Base64InputStream(InputStream in, boolean doEncode, int lineLength, byte[] lineSeparator) {
        super(in);
        this.doEncode = doEncode;
        this.base64 = new Base64(lineLength, lineSeparator);
    }

    public int read() throws IOException {
        int r = this.read(this.singleByte, 0, 1);
        while (r == 0) {
            r = this.read(this.singleByte, 0, 1);
        }
        if (r > 0) {
            return this.singleByte[0] < 0 ? 256 + this.singleByte[0] : this.singleByte[0];
        }
        return -1;
    }

    public int read(byte[] b, int offset, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (offset > b.length || offset + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (!this.base64.hasData()) {
            byte[] buf = new byte[this.doEncode ? 4096 : 8192];
            int c = this.in.read(buf);
            if (c > 0 && b.length == len) {
                this.base64.setInitialBuffer(b, offset, len);
            }
            if (this.doEncode) {
                this.base64.encode(buf, 0, c);
            } else {
                this.base64.decode(buf, 0, c);
            }
        }
        return this.base64.readResults(b, offset, len);
    }

    public boolean markSupported() {
        return false;
    }
}

