/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.util.AbstractList;
import java.util.RandomAccess;

public class BoundedArrayList<E>
extends AbstractList<E>
implements RandomAccess {
    private final E[] a;
    private final int size;

    public BoundedArrayList(E[] array, int size) {
        if (array == null) {
            throw new NullPointerException();
        }
        this.a = array;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(int index) {
        return this.a[index];
    }

    @Override
    public E set(int index, E element) {
        E oldValue = this.a[index];
        this.a[index] = element;
        return oldValue;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.a.length; ++i) {
                if (this.a[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.a.length; ++i) {
                if (!o.equals(this.a[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }
}

