/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.inject.ConstructionProxy;
import org.elasticsearch.common.inject.ConstructionProxyFactory;
import org.elasticsearch.common.inject.DefaultConstructionProxyFactory;
import org.elasticsearch.common.inject.InterceptorStackCallback;
import org.elasticsearch.common.inject.MethodAspect;
import org.elasticsearch.common.inject.internal.BytecodeGen;
import org.elasticsearch.common.inject.internal.ImmutableList;
import org.elasticsearch.common.inject.internal.ImmutableMap;
import org.elasticsearch.common.inject.internal.Lists;
import org.elasticsearch.common.inject.internal.Maps;
import org.elasticsearch.common.inject.internal.cglib.proxy.Callback;
import org.elasticsearch.common.inject.internal.cglib.proxy.CallbackFilter;
import org.elasticsearch.common.inject.internal.cglib.proxy.Enhancer;
import org.elasticsearch.common.inject.internal.cglib.proxy.MethodInterceptor;
import org.elasticsearch.common.inject.internal.cglib.proxy.MethodProxy;
import org.elasticsearch.common.inject.internal.cglib.reflect.FastClass;
import org.elasticsearch.common.inject.internal.cglib.reflect.FastConstructor;
import org.elasticsearch.common.inject.spi.InjectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProxyFactory<T>
implements ConstructionProxyFactory<T> {
    private static final MethodInterceptor NO_OP_METHOD_INTERCEPTOR = new MethodInterceptor(){

        public Object intercept(Object proxy, Method method, Object[] arguments, MethodProxy methodProxy) throws Throwable {
            return methodProxy.invokeSuper(proxy, arguments);
        }
    };
    private final InjectionPoint injectionPoint;
    private final ImmutableMap<Method, List<org.elasticsearch.common.aopalliance.intercept.MethodInterceptor>> interceptors;
    private final Class<T> declaringClass;
    private final List<Method> methods;
    private final Callback[] callbacks;
    private BytecodeGen.Visibility visibility = BytecodeGen.Visibility.PUBLIC;

    ProxyFactory(InjectionPoint injectionPoint, Iterable<MethodAspect> methodAspects) {
        this.injectionPoint = injectionPoint;
        Constructor constructor = (Constructor)injectionPoint.getMember();
        this.declaringClass = constructor.getDeclaringClass();
        ArrayList<MethodAspect> applicableAspects = Lists.newArrayList();
        for (MethodAspect methodAspect : methodAspects) {
            if (!methodAspect.matches(this.declaringClass)) continue;
            applicableAspects.add(methodAspect);
        }
        if (applicableAspects.isEmpty()) {
            this.interceptors = ImmutableMap.of();
            this.methods = ImmutableList.of();
            this.callbacks = null;
            return;
        }
        this.methods = Lists.newArrayList();
        Enhancer.getMethods(this.declaringClass, null, this.methods);
        ArrayList<MethodInterceptorsPair> methodInterceptorsPairs = Lists.newArrayList();
        for (Method method : this.methods) {
            methodInterceptorsPairs.add(new MethodInterceptorsPair(method));
        }
        boolean anyMatched = false;
        for (MethodAspect methodAspect : applicableAspects) {
            for (MethodInterceptorsPair pair : methodInterceptorsPairs) {
                if (!methodAspect.matches(pair.method)) continue;
                this.visibility = this.visibility.and(BytecodeGen.Visibility.forMember(pair.method));
                pair.addAll(methodAspect.interceptors());
                anyMatched = true;
            }
        }
        if (!anyMatched) {
            this.interceptors = ImmutableMap.of();
            this.callbacks = null;
            return;
        }
        ImmutableMap.Builder<Method, ImmutableList<org.elasticsearch.common.aopalliance.intercept.MethodInterceptor>> interceptorsMapBuilder = null;
        this.callbacks = new Callback[this.methods.size()];
        for (int i = 0; i < this.methods.size(); ++i) {
            MethodInterceptorsPair pair = (MethodInterceptorsPair)methodInterceptorsPairs.get(i);
            if (!pair.hasInterceptors()) {
                this.callbacks[i] = NO_OP_METHOD_INTERCEPTOR;
                continue;
            }
            if (interceptorsMapBuilder == null) {
                interceptorsMapBuilder = ImmutableMap.builder();
            }
            interceptorsMapBuilder.put(pair.method, ImmutableList.copyOf(pair.interceptors));
            this.callbacks[i] = new InterceptorStackCallback(pair.method, pair.interceptors);
        }
        this.interceptors = interceptorsMapBuilder != null ? interceptorsMapBuilder.build() : ImmutableMap.of();
    }

    public ImmutableMap<Method, List<org.elasticsearch.common.aopalliance.intercept.MethodInterceptor>> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public ConstructionProxy<T> create() {
        if (this.interceptors.isEmpty()) {
            return new DefaultConstructionProxyFactory(this.injectionPoint).create();
        }
        Object[] callbackTypes = new Class[this.methods.size()];
        Arrays.fill(callbackTypes, MethodInterceptor.class);
        Enhancer enhancer = BytecodeGen.newEnhancer(this.declaringClass, this.visibility);
        enhancer.setCallbackFilter(new IndicesCallbackFilter(this.declaringClass, this.methods));
        enhancer.setCallbackTypes((Class[])callbackTypes);
        return new ProxyConstructor(enhancer, this.injectionPoint, this.callbacks, this.interceptors);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProxyConstructor<T>
    implements ConstructionProxy<T> {
        final Class<?> enhanced;
        final InjectionPoint injectionPoint;
        final Constructor<T> constructor;
        final Callback[] callbacks;
        final FastConstructor fastConstructor;
        final ImmutableMap<Method, List<org.elasticsearch.common.aopalliance.intercept.MethodInterceptor>> methodInterceptors;

        ProxyConstructor(Enhancer enhancer, InjectionPoint injectionPoint, Callback[] callbacks, ImmutableMap<Method, List<org.elasticsearch.common.aopalliance.intercept.MethodInterceptor>> methodInterceptors) {
            this.enhanced = enhancer.createClass();
            this.injectionPoint = injectionPoint;
            this.constructor = (Constructor)injectionPoint.getMember();
            this.callbacks = callbacks;
            this.methodInterceptors = methodInterceptors;
            FastClass fastClass = BytecodeGen.newFastClass(this.enhanced, BytecodeGen.Visibility.forMember(this.constructor));
            this.fastConstructor = fastClass.getConstructor(this.constructor.getParameterTypes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T newInstance(Object[] arguments) throws InvocationTargetException {
            Enhancer.registerCallbacks(this.enhanced, this.callbacks);
            try {
                Object object = this.fastConstructor.newInstance(arguments);
                return (T)object;
            }
            finally {
                Enhancer.registerCallbacks(this.enhanced, null);
            }
        }

        @Override
        public InjectionPoint getInjectionPoint() {
            return this.injectionPoint;
        }

        @Override
        public Constructor<T> getConstructor() {
            return this.constructor;
        }

        @Override
        public ImmutableMap<Method, List<org.elasticsearch.common.aopalliance.intercept.MethodInterceptor>> getMethodInterceptors() {
            return this.methodInterceptors;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndicesCallbackFilter
    implements CallbackFilter {
        final Class<?> declaringClass;
        final Map<Method, Integer> indices;

        IndicesCallbackFilter(Class<?> declaringClass, List<Method> methods) {
            this.declaringClass = declaringClass;
            HashMap<Method, Integer> indices = Maps.newHashMap();
            for (int i = 0; i < methods.size(); ++i) {
                Method method = methods.get(i);
                indices.put(method, i);
            }
            this.indices = indices;
        }

        @Override
        public int accept(Method method) {
            return this.indices.get(method);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof IndicesCallbackFilter && ((IndicesCallbackFilter)o).declaringClass == this.declaringClass;
        }

        public int hashCode() {
            return this.declaringClass.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodInterceptorsPair {
        final Method method;
        List<org.elasticsearch.common.aopalliance.intercept.MethodInterceptor> interceptors;

        MethodInterceptorsPair(Method method) {
            this.method = method;
        }

        void addAll(List<org.elasticsearch.common.aopalliance.intercept.MethodInterceptor> interceptors) {
            if (this.interceptors == null) {
                this.interceptors = Lists.newArrayList();
            }
            this.interceptors.addAll(interceptors);
        }

        boolean hasInterceptors() {
            return this.interceptors != null;
        }
    }
}

