/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;

public class BoostScoreFunction
implements ScoreFunction {
    private final float boost;

    public BoostScoreFunction(float boost) {
        this.boost = boost;
    }

    public float getBoost() {
        return this.boost;
    }

    @Override
    public void setNextReader(IndexReader reader) {
    }

    @Override
    public float score(int docId, float subQueryScore) {
        return subQueryScore * this.boost;
    }

    @Override
    public Explanation explain(int docId, Explanation subQueryExpl) {
        Explanation exp = new Explanation(this.boost * subQueryExpl.getValue(), "static boost function: product of:");
        exp.addDetail(subQueryExpl);
        exp.addDetail(new Explanation(this.boost, "boostFactor"));
        return exp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoostScoreFunction that = (BoostScoreFunction)o;
        return Float.compare(that.boost, this.boost) == 0;
    }

    public int hashCode() {
        return this.boost != 0.0f ? Float.floatToIntBits(this.boost) : 0;
    }
}

