/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.sh;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.MVELInterpretedRuntime;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.integration.impl.MapVariableResolverFactory;
import org.elasticsearch.common.mvel2.sh.Command;
import org.elasticsearch.common.mvel2.sh.CommandException;
import org.elasticsearch.common.mvel2.sh.command.basic.BasicCommandSet;
import org.elasticsearch.common.mvel2.sh.command.file.FileCommandSet;
import org.elasticsearch.common.mvel2.templates.TemplateRuntime;
import org.elasticsearch.common.mvel2.util.PropertyTools;
import org.elasticsearch.common.mvel2.util.StringAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellSession {
    public static final String PROMPT_VAR = "$PROMPT";
    private static final String[] EMPTY = new String[0];
    private final Map<String, Command> commands;
    private Map<String, Object> variables;
    private Map<String, String> env;
    private Object ctxObject;
    ParserContext pCtx;
    VariableResolverFactory lvrf;
    private int depth;
    private int cdepth;
    private boolean multi;
    private int multiIndentSize;
    private PrintStream out;
    private String prompt;
    private String commandBuffer;
    StringAppender inBuffer;
    final BufferedReader readBuffer;

    public ShellSession() {
        block3: {
            this.commands = new HashMap<String, Command>();
            this.pCtx = new ParserContext();
            this.multi = false;
            this.multiIndentSize = 0;
            this.out = System.out;
            this.inBuffer = new StringAppender();
            this.readBuffer = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("Starting session...");
            this.variables = new HashMap<String, Object>();
            this.env = new HashMap<String, String>();
            this.commands.putAll(new BasicCommandSet().load());
            this.commands.putAll(new FileCommandSet().load());
            this.env.put(PROMPT_VAR, "[@{ new java.text.SimpleDateFormat('hh:mmaa').format(new java.util.Date(System.currentTimeMillis()))}] mvel2$ ");
            this.env.put("$OS_NAME", System.getProperty("os.name"));
            this.env.put("$OS_VERSION", System.getProperty("os.version"));
            this.env.put("$JAVA_VERSION", System.getProperty("java.version"));
            this.env.put("$CWD", new File(".").getAbsolutePath());
            this.env.put("$COMMAND_PASSTRU", "false");
            this.env.put("$PRINTOUTPUT", "true");
            this.env.put("$ECHO", "false");
            this.env.put("$SHOW_TRACES", "true");
            this.env.put("$USE_OPTIMIZER_ALWAYS", "false");
            this.env.put("$PATH", "");
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(".mvelsh.properties");
                Enumeration<String> enumer = bundle.getKeys();
                while (enumer.hasMoreElements()) {
                    String key = enumer.nextElement();
                    this.env.put(key, bundle.getString(key));
                }
            }
            catch (MissingResourceException e) {
                System.out.println("No config file found.  Loading default config.");
                if (PropertyTools.contains(System.getProperty("os.name").toLowerCase(), "windows")) break block3;
                this.env.put("$PATH", "/bin:/usr/bin:/sbin:/usr/sbin");
            }
        }
        this.lvrf = new MapVariableResolverFactory(this.variables, new MapVariableResolverFactory(this.env));
    }

    public ShellSession(String init) {
        this();
        this.exec(init);
    }

    private void _exec() {
        String[] inTokens;
        final PrintStream sysPrintStream = System.out;
        PrintStream sysErrorStream = System.err;
        InputStream sysInputStream = System.in;
        if ("true".equals(this.env.get("$ECHO"))) {
            this.out.println(">" + this.commandBuffer);
            this.out.flush();
        }
        if ((inTokens = this.inBuffer.append(this.commandBuffer).toString().split("\\s")).length != 0 && this.commands.containsKey(inTokens[0])) {
            String[] passParameters;
            this.commandBuffer = null;
            if (inTokens.length > 1) {
                passParameters = new String[inTokens.length - 1];
                System.arraycopy(inTokens, 1, passParameters, 0, passParameters.length);
            } else {
                passParameters = EMPTY;
            }
            try {
                this.commands.get(inTokens[0]).execute(this, passParameters);
            }
            catch (CommandException e) {
                this.out.append("Error: ").append(e.getMessage()).append("\n");
            }
        } else {
            Object outputBuffer;
            this.commandBuffer = null;
            try {
                if (this.shouldDefer(this.inBuffer)) {
                    this.multi = true;
                    return;
                }
                this.multi = false;
                if (Boolean.parseBoolean(this.env.get("$USE_OPTIMIZER_ALWAYS"))) {
                    outputBuffer = MVEL.executeExpression((Object)MVEL.compileExpression(this.inBuffer.toString()), this.ctxObject, this.lvrf);
                } else {
                    MVELInterpretedRuntime runtime = new MVELInterpretedRuntime(this.inBuffer.toString(), this.ctxObject, this.lvrf);
                    runtime.newContext(this.pCtx);
                    outputBuffer = runtime.parse();
                }
            }
            catch (Exception e) {
                if ("true".equals(this.env.get("$COMMAND_PASSTHRU"))) {
                    String[] paths;
                    String s = inTokens[0];
                    if (s.startsWith("./")) {
                        s = new File(this.env.get("$CWD")).getAbsolutePath() + s.substring(s.indexOf(47));
                        paths = new String[]{s};
                    } else {
                        paths = this.env.get("$PATH").split("(:|;)");
                    }
                    boolean successfulExec = false;
                    for (String execPath : paths) {
                        File execFile = new File(execPath + "/" + s);
                        if (!execFile.exists() || !execFile.isFile()) continue;
                        successfulExec = true;
                        String[] execString = new String[inTokens.length];
                        execString[0] = execFile.getAbsolutePath();
                        System.arraycopy(inTokens, 1, execString, 1, inTokens.length - 1);
                        try {
                            final Process p = Runtime.getRuntime().exec(execString);
                            final OutputStream outStream = p.getOutputStream();
                            final InputStream inStream = p.getInputStream();
                            InputStream errStream = p.getErrorStream();
                            final RunState runState = new RunState(this);
                            Thread pollingThread = new Thread(new Runnable(){

                                public void run() {
                                    byte[] buf = new byte[25];
                                    try {
                                        while (true) {
                                            int read;
                                            if ((read = inStream.read(buf)) > 0) {
                                                for (int i = 0; i < read; ++i) {
                                                    sysPrintStream.print((char)buf[i]);
                                                }
                                                sysPrintStream.flush();
                                                continue;
                                            }
                                            if (!runState.isRunning()) break;
                                        }
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    sysPrintStream.flush();
                                    if (!ShellSession.this.multi) {
                                        ShellSession.this.multiIndentSize = (ShellSession.this.prompt = String.valueOf(TemplateRuntime.eval((String)ShellSession.this.env.get(ShellSession.PROMPT_VAR), ShellSession.this.variables))).length();
                                        ShellSession.this.out.append(ShellSession.this.prompt);
                                    } else {
                                        ShellSession.this.out.append(">").append(ShellSession.this.indent(ShellSession.this.multiIndentSize - 1 + ShellSession.this.depth * 4));
                                    }
                                }
                            });
                            Thread watchThread = new Thread(new Runnable(){

                                public void run() {
                                    Thread runningThread = new Thread(new Runnable(){

                                        public void run() {
                                            try {
                                                block2: while (runState.isRunning()) {
                                                    String read;
                                                    while ((read = ShellSession.this.readBuffer.readLine()) != null) {
                                                        if (runState.isRunning()) {
                                                            for (char c : read.toCharArray()) {
                                                                outStream.write((byte)c);
                                                            }
                                                            continue;
                                                        }
                                                        runState.getSession().setCommandBuffer(read);
                                                        continue block2;
                                                    }
                                                }
                                                outStream.write(10);
                                                outStream.flush();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                    });
                                    runningThread.setPriority(1);
                                    runningThread.start();
                                    try {
                                        p.waitFor();
                                    }
                                    catch (InterruptedException e) {
                                        // empty catch block
                                    }
                                    sysPrintStream.flush();
                                    runState.setRunning(false);
                                    try {
                                        runningThread.join();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                            });
                            pollingThread.setPriority(1);
                            pollingThread.start();
                            watchThread.setPriority(1);
                            watchThread.start();
                            watchThread.join();
                            try {
                                pollingThread.notify();
                            }
                            catch (Exception ne) {}
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    if (successfulExec) {
                        this.inBuffer.reset();
                        return;
                    }
                }
                ByteArrayOutputStream stackTraceCap = new ByteArrayOutputStream();
                PrintStream capture = new PrintStream(stackTraceCap);
                e.printStackTrace(capture);
                capture.flush();
                this.env.put("$LAST_STACK_TRACE", new String(stackTraceCap.toByteArray()));
                if (Boolean.parseBoolean(this.env.get("$SHOW_TRACE"))) {
                    this.out.println(this.env.get("$LAST_STACK_TRACE"));
                } else {
                    this.out.println(e.toString());
                }
                this.inBuffer.reset();
                return;
            }
            if (outputBuffer != null && "true".equals(this.env.get("$PRINTOUTPUT"))) {
                this.out.println(String.valueOf(outputBuffer));
            }
        }
        this.inBuffer.reset();
    }

    public void run() {
        BufferedReader readBuffer = new BufferedReader(new InputStreamReader(System.in));
        try {
            while (true) {
                this.printPrompt();
                if (this.commandBuffer == null) {
                    this.commandBuffer = readBuffer.readLine();
                }
                this._exec();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("unexpected exception. exiting.");
            return;
        }
    }

    public void printPrompt() {
        if (!this.multi) {
            this.prompt = String.valueOf(TemplateRuntime.eval(this.env.get(PROMPT_VAR), this.variables));
            this.multiIndentSize = this.prompt.length();
            this.out.append(this.prompt);
        } else {
            this.out.append(">").append(this.indent(this.multiIndentSize - 1 + this.depth * 4));
        }
    }

    public boolean shouldDefer(StringAppender inBuf) {
        char[] buffer = new char[inBuf.length()];
        inBuf.getChars(0, inBuf.length(), buffer, 0);
        this.cdepth = 0;
        this.depth = 0;
        block6: for (int i = 0; i < buffer.length; ++i) {
            switch (buffer[i]) {
                case '/': {
                    if (i + 1 >= buffer.length || buffer[i + 1] != '*') continue block6;
                    ++this.cdepth;
                    continue block6;
                }
                case '*': {
                    if (i + 1 >= buffer.length || buffer[i + 1] != '/') continue block6;
                    --this.cdepth;
                    continue block6;
                }
                case '{': {
                    ++this.depth;
                    continue block6;
                }
                case '}': {
                    --this.depth;
                }
            }
        }
        return this.depth + this.cdepth > 0;
    }

    public String indent(int size) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            sbuf.append(" ");
        }
        return sbuf.toString();
    }

    public Map<String, Command> getCommands() {
        return this.commands;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public Object getCtxObject() {
        return this.ctxObject;
    }

    public void setCtxObject(Object ctxObject) {
        this.ctxObject = ctxObject;
    }

    public String getCommandBuffer() {
        return this.commandBuffer;
    }

    public void setCommandBuffer(String commandBuffer) {
        this.commandBuffer = commandBuffer;
    }

    public void exec(String command) {
        for (String c : command.split("\n")) {
            this.inBuffer.append(c);
            this._exec();
        }
    }

    public static final class RunState {
        private boolean running = true;
        private ShellSession session;

        public RunState(ShellSession session) {
            this.session = session;
        }

        public ShellSession getSession() {
            return this.session;
        }

        public void setSession(ShellSession session) {
            this.session = session;
        }

        public boolean isRunning() {
            return this.running;
        }

        public void setRunning(boolean running) {
            this.running = running;
        }
    }
}

