/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.elasticsearch.common.netty.buffer.AbstractChannelBufferFactory;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBufferFactory;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;

public class DirectChannelBufferFactory
extends AbstractChannelBufferFactory {
    private static final DirectChannelBufferFactory INSTANCE_BE = new DirectChannelBufferFactory(ByteOrder.BIG_ENDIAN);
    private static final DirectChannelBufferFactory INSTANCE_LE = new DirectChannelBufferFactory(ByteOrder.LITTLE_ENDIAN);
    private final Object bigEndianLock = new Object();
    private final Object littleEndianLock = new Object();
    private final int preallocatedBufferCapacity;
    private ChannelBuffer preallocatedBigEndianBuffer = null;
    private int preallocatedBigEndianBufferPosition;
    private ChannelBuffer preallocatedLittleEndianBuffer = null;
    private int preallocatedLittleEndianBufferPosition;

    public static ChannelBufferFactory getInstance() {
        return INSTANCE_BE;
    }

    public static ChannelBufferFactory getInstance(ByteOrder defaultEndianness) {
        if (defaultEndianness == ByteOrder.BIG_ENDIAN) {
            return INSTANCE_BE;
        }
        if (defaultEndianness == ByteOrder.LITTLE_ENDIAN) {
            return INSTANCE_LE;
        }
        if (defaultEndianness == null) {
            throw new NullPointerException("defaultEndianness");
        }
        throw new IllegalStateException("Should not reach here");
    }

    public DirectChannelBufferFactory() {
        this(ByteOrder.BIG_ENDIAN);
    }

    public DirectChannelBufferFactory(int preallocatedBufferCapacity) {
        this(ByteOrder.BIG_ENDIAN, preallocatedBufferCapacity);
    }

    public DirectChannelBufferFactory(ByteOrder defaultOrder) {
        this(defaultOrder, 0x100000);
    }

    public DirectChannelBufferFactory(ByteOrder defaultOrder, int preallocatedBufferCapacity) {
        super(defaultOrder);
        if (preallocatedBufferCapacity <= 0) {
            throw new IllegalArgumentException("preallocatedBufferCapacity must be greater than 0: " + preallocatedBufferCapacity);
        }
        this.preallocatedBufferCapacity = preallocatedBufferCapacity;
    }

    public ChannelBuffer getBuffer(ByteOrder order, int capacity) {
        if (order == null) {
            throw new NullPointerException("order");
        }
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity: " + capacity);
        }
        if (capacity == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        if (capacity >= this.preallocatedBufferCapacity) {
            return ChannelBuffers.directBuffer(order, capacity);
        }
        ChannelBuffer slice = order == ByteOrder.BIG_ENDIAN ? this.allocateBigEndianBuffer(capacity) : this.allocateLittleEndianBuffer(capacity);
        slice.clear();
        return slice;
    }

    public ChannelBuffer getBuffer(ByteOrder order, byte[] array, int offset, int length) {
        if (array == null) {
            throw new NullPointerException("array");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset: " + offset);
        }
        if (length == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        if (offset + length > array.length) {
            throw new IndexOutOfBoundsException("length: " + length);
        }
        ChannelBuffer buf = this.getBuffer(order, length);
        buf.writeBytes(array, offset, length);
        return buf;
    }

    public ChannelBuffer getBuffer(ByteBuffer nioBuffer) {
        if (!nioBuffer.isReadOnly() && nioBuffer.isDirect()) {
            return ChannelBuffers.wrappedBuffer(nioBuffer);
        }
        ChannelBuffer buf = this.getBuffer(nioBuffer.order(), nioBuffer.remaining());
        int pos = nioBuffer.position();
        buf.writeBytes(nioBuffer);
        nioBuffer.position(pos);
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelBuffer allocateBigEndianBuffer(int capacity) {
        ChannelBuffer slice;
        Object object = this.bigEndianLock;
        synchronized (object) {
            if (this.preallocatedBigEndianBuffer == null) {
                this.preallocatedBigEndianBuffer = ChannelBuffers.directBuffer(ByteOrder.BIG_ENDIAN, this.preallocatedBufferCapacity);
                slice = this.preallocatedBigEndianBuffer.slice(0, capacity);
                this.preallocatedBigEndianBufferPosition = capacity;
            } else if (this.preallocatedBigEndianBuffer.capacity() - this.preallocatedBigEndianBufferPosition >= capacity) {
                slice = this.preallocatedBigEndianBuffer.slice(this.preallocatedBigEndianBufferPosition, capacity);
                this.preallocatedBigEndianBufferPosition += capacity;
            } else {
                this.preallocatedBigEndianBuffer = ChannelBuffers.directBuffer(ByteOrder.BIG_ENDIAN, this.preallocatedBufferCapacity);
                slice = this.preallocatedBigEndianBuffer.slice(0, capacity);
                this.preallocatedBigEndianBufferPosition = capacity;
            }
        }
        return slice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelBuffer allocateLittleEndianBuffer(int capacity) {
        ChannelBuffer slice;
        Object object = this.littleEndianLock;
        synchronized (object) {
            if (this.preallocatedLittleEndianBuffer == null) {
                this.preallocatedLittleEndianBuffer = ChannelBuffers.directBuffer(ByteOrder.LITTLE_ENDIAN, this.preallocatedBufferCapacity);
                slice = this.preallocatedLittleEndianBuffer.slice(0, capacity);
                this.preallocatedLittleEndianBufferPosition = capacity;
            } else if (this.preallocatedLittleEndianBuffer.capacity() - this.preallocatedLittleEndianBufferPosition >= capacity) {
                slice = this.preallocatedLittleEndianBuffer.slice(this.preallocatedLittleEndianBufferPosition, capacity);
                this.preallocatedLittleEndianBufferPosition += capacity;
            } else {
                this.preallocatedLittleEndianBuffer = ChannelBuffers.directBuffer(ByteOrder.LITTLE_ENDIAN, this.preallocatedBufferCapacity);
                slice = this.preallocatedLittleEndianBuffer.slice(0, capacity);
                this.preallocatedLittleEndianBufferPosition = capacity;
            }
        }
        return slice;
    }
}

