/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent.jsr166y;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.elasticsearch.common.util.concurrent.jsr166y.ForkJoinPool;
import org.elasticsearch.common.util.concurrent.jsr166y.ForkJoinWorkerThread;
import sun.misc.Unsafe;

public abstract class ForkJoinTask<V>
implements Future<V>,
Serializable {
    volatile int status;
    private static final int NORMAL = -1;
    private static final int CANCELLED = -2;
    private static final int EXCEPTIONAL = -3;
    private static final int SIGNAL = 1;
    static final Map<ForkJoinTask<?>, Throwable> exceptionMap = Collections.synchronizedMap(new WeakHashMap());
    private static final long serialVersionUID = -7721805057305804111L;
    private static final Unsafe UNSAFE = ForkJoinTask.getUnsafe();
    private static final long statusOffset = ForkJoinTask.objectFieldOffset("status", ForkJoinTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCompletion(int completion) {
        int s;
        while ((s = this.status) >= 0) {
            if (!UNSAFE.compareAndSwapInt(this, statusOffset, s, completion)) continue;
            if (s == 0) break;
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                this.notifyAll();
                break;
            }
        }
    }

    private void setExceptionalCompletion(Throwable rex) {
        exceptionMap.put(this, rex);
        this.setCompletion(-3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void internalAwaitDone(long millis, int nanos) {
        int s = this.status;
        if (s == 0 && UNSAFE.compareAndSwapInt(this, statusOffset, 0, 1) || s > 0) {
            try {
                ForkJoinTask forkJoinTask = this;
                synchronized (forkJoinTask) {
                    if (this.status > 0) {
                        this.wait(millis, nanos);
                    } else {
                        this.notifyAll();
                    }
                }
            }
            catch (InterruptedException ie) {
                this.cancelIfTerminating();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void externalAwaitDone() {
        if (this.status < 0) return;
        boolean interrupted = false;
        ForkJoinTask forkJoinTask = this;
        synchronized (forkJoinTask) {
            while (true) {
                int s;
                if ((s = this.status) == 0) {
                    UNSAFE.compareAndSwapInt(this, statusOffset, 0, 1);
                    continue;
                }
                if (s < 0) {
                    this.notifyAll();
                    // MONITOREXIT @DISABLED, blocks:[2, 4, 7] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (!interrupted) return;
                    break;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
        }
        Thread.currentThread().interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void externalInterruptibleAwaitDone(boolean timed, long nanos) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.status >= 0) {
            long startTime = timed ? System.nanoTime() : 0L;
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                while (true) {
                    int s;
                    if ((s = this.status) == 0) {
                        UNSAFE.compareAndSwapInt(this, statusOffset, 0, 1);
                        continue;
                    }
                    if (s < 0) {
                        this.notifyAll();
                        break;
                    }
                    if (!timed) {
                        this.wait();
                        continue;
                    }
                    long nt = nanos - (System.nanoTime() - startTime);
                    if (nt <= 0L) break;
                    this.wait(nt / 1000000L, (int)(nt % 1000000L));
                }
            }
        }
    }

    final void quietlyExec() {
        try {
            if (this.status < 0 || !this.exec()) {
                return;
            }
        }
        catch (Throwable rex) {
            this.setExceptionalCompletion(rex);
            return;
        }
        this.setCompletion(-1);
    }

    public final ForkJoinTask<V> fork() {
        ((ForkJoinWorkerThread)Thread.currentThread()).pushTask(this);
        return this;
    }

    public final V join() {
        Throwable ex;
        this.quietlyJoin();
        if (this.status < -1 && (ex = this.getException()) != null) {
            UNSAFE.throwException(ex);
        }
        return this.getRawResult();
    }

    public final V invoke() {
        Throwable ex;
        this.quietlyInvoke();
        if (this.status < -1 && (ex = this.getException()) != null) {
            UNSAFE.throwException(ex);
        }
        return this.getRawResult();
    }

    public static void invokeAll(ForkJoinTask<?> t1, ForkJoinTask<?> t2) {
        t2.fork();
        t1.invoke();
        t2.join();
    }

    public static void invokeAll(ForkJoinTask<?> ... tasks) {
        ForkJoinTask<?> t;
        int last;
        int i;
        Throwable ex = null;
        for (i = last = tasks.length - 1; i >= 0; --i) {
            t = tasks[i];
            if (t == null) {
                if (ex != null) continue;
                ex = new NullPointerException();
                continue;
            }
            if (i != 0) {
                t.fork();
                continue;
            }
            t.quietlyInvoke();
            if (ex != null || t.status >= -1) continue;
            ex = t.getException();
        }
        for (i = 1; i <= last; ++i) {
            t = tasks[i];
            if (t == null) continue;
            if (ex != null) {
                t.cancel(false);
                continue;
            }
            t.quietlyJoin();
            if (ex != null || t.status >= -1) continue;
            ex = t.getException();
        }
        if (ex != null) {
            UNSAFE.throwException(ex);
        }
    }

    public static <T extends ForkJoinTask<?>> Collection<T> invokeAll(Collection<T> tasks) {
        ForkJoinTask t;
        int last;
        int i;
        if (!(tasks instanceof RandomAccess) || !(tasks instanceof List)) {
            ForkJoinTask.invokeAll(tasks.toArray(new ForkJoinTask[tasks.size()]));
            return tasks;
        }
        List ts = (List)tasks;
        Throwable ex = null;
        for (i = last = ts.size() - 1; i >= 0; --i) {
            t = (ForkJoinTask)ts.get(i);
            if (t == null) {
                if (ex != null) continue;
                ex = new NullPointerException();
                continue;
            }
            if (i != 0) {
                t.fork();
                continue;
            }
            t.quietlyInvoke();
            if (ex != null || t.status >= -1) continue;
            ex = t.getException();
        }
        for (i = 1; i <= last; ++i) {
            t = (ForkJoinTask)ts.get(i);
            if (t == null) continue;
            if (ex != null) {
                t.cancel(false);
                continue;
            }
            t.quietlyJoin();
            if (ex != null || t.status >= -1) continue;
            ex = t.getException();
        }
        if (ex != null) {
            UNSAFE.throwException(ex);
        }
        return tasks;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.setCompletion(-2);
        return this.status == -2;
    }

    final void cancelIgnoringExceptions() {
        try {
            this.cancel(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    final void cancelIfTerminating() {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread && ((ForkJoinWorkerThread)t).isTerminating()) {
            try {
                this.cancel(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public final boolean isDone() {
        return this.status < 0;
    }

    @Override
    public final boolean isCancelled() {
        return this.status == -2;
    }

    public final boolean isCompletedAbnormally() {
        return this.status < -1;
    }

    public final boolean isCompletedNormally() {
        return this.status == -1;
    }

    public final Throwable getException() {
        int s = this.status;
        return s >= -1 ? null : (s == -2 ? new CancellationException() : exceptionMap.get(this));
    }

    public void completeExceptionally(Throwable ex) {
        this.setExceptionalCompletion(ex instanceof RuntimeException || ex instanceof Error ? ex : new RuntimeException(ex));
    }

    public void complete(V value) {
        try {
            this.setRawResult(value);
        }
        catch (Throwable rex) {
            this.setExceptionalCompletion(rex);
            return;
        }
        this.setCompletion(-1);
    }

    @Override
    public final V get() throws InterruptedException, ExecutionException {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            this.quietlyJoin();
        } else {
            this.externalInterruptibleAwaitDone(false, 0L);
        }
        int s = this.status;
        if (s != -1) {
            Throwable ex;
            if (s == -2) {
                throw new CancellationException();
            }
            if (s == -3 && (ex = exceptionMap.get(this)) != null) {
                throw new ExecutionException(ex);
            }
        }
        return this.getRawResult();
    }

    @Override
    public final V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long nanos = unit.toNanos(timeout);
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ((ForkJoinWorkerThread)t).joinTask(this, true, nanos);
        } else {
            this.externalInterruptibleAwaitDone(true, nanos);
        }
        int s = this.status;
        if (s != -1) {
            Throwable ex;
            if (s == -2) {
                throw new CancellationException();
            }
            if (s == -3 && (ex = exceptionMap.get(this)) != null) {
                throw new ExecutionException(ex);
            }
            throw new TimeoutException();
        }
        return this.getRawResult();
    }

    public final void quietlyJoin() {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread w = (ForkJoinWorkerThread)t;
            if (this.status >= 0) {
                if (w.unpushTask(this)) {
                    boolean completed;
                    try {
                        completed = this.exec();
                    }
                    catch (Throwable rex) {
                        this.setExceptionalCompletion(rex);
                        return;
                    }
                    if (completed) {
                        this.setCompletion(-1);
                        return;
                    }
                }
                w.joinTask(this, false, 0L);
            }
        } else {
            this.externalAwaitDone();
        }
    }

    public final void quietlyInvoke() {
        if (this.status >= 0) {
            boolean completed;
            try {
                completed = this.exec();
            }
            catch (Throwable rex) {
                this.setExceptionalCompletion(rex);
                return;
            }
            if (completed) {
                this.setCompletion(-1);
            } else {
                this.quietlyJoin();
            }
        }
    }

    public static void helpQuiesce() {
        ((ForkJoinWorkerThread)Thread.currentThread()).helpQuiescePool();
    }

    public void reinitialize() {
        if (this.status == -3) {
            exceptionMap.remove(this);
        }
        this.status = 0;
    }

    public static ForkJoinPool getPool() {
        Thread t = Thread.currentThread();
        return t instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t).pool : null;
    }

    public static boolean inForkJoinPool() {
        return Thread.currentThread() instanceof ForkJoinWorkerThread;
    }

    public boolean tryUnfork() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).unpushTask(this);
    }

    public static int getQueuedTaskCount() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).getQueueSize();
    }

    public static int getSurplusQueuedTaskCount() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).getEstimatedSurplusTaskCount();
    }

    public abstract V getRawResult();

    protected abstract void setRawResult(V var1);

    protected abstract boolean exec();

    protected static ForkJoinTask<?> peekNextLocalTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).peekTask();
    }

    protected static ForkJoinTask<?> pollNextLocalTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).pollLocalTask();
    }

    protected static ForkJoinTask<?> pollTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).pollTask();
    }

    public static ForkJoinTask<?> adapt(Runnable runnable) {
        return new AdaptedRunnable<Object>(runnable, null);
    }

    public static <T> ForkJoinTask<T> adapt(Runnable runnable, T result) {
        return new AdaptedRunnable<T>(runnable, result);
    }

    public static <T> ForkJoinTask<T> adapt(Callable<? extends T> callable) {
        return new AdaptedCallable<T>(callable);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.getException());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Object ex = s.readObject();
        if (ex != null) {
            this.setExceptionalCompletion((Throwable)ex);
        }
    }

    private static long objectFieldOffset(String field, Class<?> klazz) {
        try {
            return UNSAFE.objectFieldOffset(klazz.getDeclaredField(field));
        }
        catch (NoSuchFieldException e) {
            NoSuchFieldError error = new NoSuchFieldError(field);
            error.initCause(e);
            throw error;
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f = Unsafe.class.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        return (Unsafe)f.get(null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    static final class AdaptedCallable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Callable<? extends T> callable;
        T result;
        private static final long serialVersionUID = 2838392045355241008L;

        AdaptedCallable(Callable<? extends T> callable) {
            if (callable == null) {
                throw new NullPointerException();
            }
            this.callable = callable;
        }

        @Override
        public T getRawResult() {
            return this.result;
        }

        @Override
        public void setRawResult(T v) {
            this.result = v;
        }

        @Override
        public boolean exec() {
            try {
                this.result = this.callable.call();
                return true;
            }
            catch (Error err) {
                throw err;
            }
            catch (RuntimeException rex) {
                throw rex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    static final class AdaptedRunnable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Runnable runnable;
        final T resultOnCompletion;
        T result;
        private static final long serialVersionUID = 5232453952276885070L;

        AdaptedRunnable(Runnable runnable, T result) {
            if (runnable == null) {
                throw new NullPointerException();
            }
            this.runnable = runnable;
            this.resultOnCompletion = result;
        }

        @Override
        public T getRawResult() {
            return this.result;
        }

        @Override
        public void setRawResult(T v) {
            this.result = v;
        }

        @Override
        public boolean exec() {
            this.runnable.run();
            this.result = this.resultOnCompletion;
            return true;
        }

        @Override
        public void run() {
            this.invoke();
        }
    }
}

