/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zookeeper;

import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.discovery.zen.ping.ZenPing;
import org.elasticsearch.discovery.zen.ping.ZenPingService;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastZenPing;
import org.elasticsearch.discovery.zookeeper.ZooKeeperUnicastHostsProvider;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class ZooKeeperDiscovery
extends ZenDiscovery {
    @Inject
    public ZooKeeperDiscovery(Settings settings, ClusterName clusterName, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ZenPingService pingService) {
        super(settings, clusterName, threadPool, transportService, clusterService, pingService);
        ImmutableList<? extends ZenPing> zenPings = pingService.zenPings();
        UnicastZenPing unicastZenPing = null;
        for (ZenPing zenPing : zenPings) {
            if (!(zenPing instanceof UnicastZenPing)) continue;
            unicastZenPing = (UnicastZenPing)zenPing;
            break;
        }
        unicastZenPing.addHostsProvider(new ZooKeeperUnicastHostsProvider(settings));
        pingService.zenPings(ImmutableList.of(unicastZenPing));
    }
}

