/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.util.Map;
import org.apache.lucene.document.Field;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.xcontent.AbstractFieldMapper;
import org.elasticsearch.index.mapper.xcontent.ContentPath;
import org.elasticsearch.index.mapper.xcontent.NumberFieldMapper;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;

public class XContentTypeParsers {
    public static void parseNumberField(NumberFieldMapper.Builder builder, String name, Map<String, Object> numberNode, XContentMapper.TypeParser.ParserContext parserContext) {
        XContentTypeParsers.parseField(builder, name, numberNode, parserContext);
        for (Map.Entry<String, Object> entry : numberNode.entrySet()) {
            String propName = Strings.toUnderscoreCase(entry.getKey());
            Object propNode = entry.getValue();
            if (!propName.equals("precision_step")) continue;
            builder.precisionStep(XContentMapValues.nodeIntegerValue(propNode));
        }
    }

    public static void parseField(AbstractFieldMapper.Builder builder, String name, Map<String, Object> fieldNode, XContentMapper.TypeParser.ParserContext parserContext) {
        for (Map.Entry<String, Object> entry : fieldNode.entrySet()) {
            NamedAnalyzer analyzer;
            String propName = Strings.toUnderscoreCase(entry.getKey());
            Object propNode = entry.getValue();
            if (propName.equals("index_name")) {
                builder.indexName(propNode.toString());
                continue;
            }
            if (propName.equals("store")) {
                builder.store(XContentTypeParsers.parseStore(name, propNode.toString()));
                continue;
            }
            if (propName.equals("index")) {
                builder.index(XContentTypeParsers.parseIndex(name, propNode.toString()));
                continue;
            }
            if (propName.equals("term_vector")) {
                builder.termVector(XContentTypeParsers.parseTermVector(name, propNode.toString()));
                continue;
            }
            if (propName.equals("boost")) {
                builder.boost(XContentMapValues.nodeFloatValue(propNode));
                continue;
            }
            if (propName.equals("omit_norms")) {
                builder.omitNorms(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("omit_term_freq_and_positions")) {
                builder.omitTermFreqAndPositions(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("index_analyzer")) {
                analyzer = parserContext.analysisService().analyzer(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("Analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                }
                builder.indexAnalyzer(analyzer);
                continue;
            }
            if (propName.equals("search_analyzer")) {
                analyzer = parserContext.analysisService().analyzer(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("Analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                }
                builder.searchAnalyzer(analyzer);
                continue;
            }
            if (propName.equals("analyzer")) {
                analyzer = parserContext.analysisService().analyzer(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("Analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                }
                builder.indexAnalyzer(analyzer);
                builder.searchAnalyzer(analyzer);
                continue;
            }
            if (!propName.equals("include_in_all")) continue;
            builder.includeInAll(XContentMapValues.nodeBooleanValue(propNode));
        }
    }

    public static FormatDateTimeFormatter parseDateTimeFormatter(String fieldName, Object node) {
        return Joda.forPattern(node.toString());
    }

    public static Field.TermVector parseTermVector(String fieldName, String termVector) throws MapperParsingException {
        if ("no".equals(termVector = Strings.toUnderscoreCase(termVector))) {
            return Field.TermVector.NO;
        }
        if ("yes".equals(termVector)) {
            return Field.TermVector.YES;
        }
        if ("with_offsets".equals(termVector)) {
            return Field.TermVector.WITH_OFFSETS;
        }
        if ("with_positions".equals(termVector)) {
            return Field.TermVector.WITH_POSITIONS;
        }
        if ("with_positions_offsets".equals(termVector)) {
            return Field.TermVector.WITH_POSITIONS_OFFSETS;
        }
        throw new MapperParsingException("Wrong value for termVector [" + termVector + "] for field [" + fieldName + "]");
    }

    public static Field.Index parseIndex(String fieldName, String index) throws MapperParsingException {
        if ("no".equals(index = Strings.toUnderscoreCase(index))) {
            return Field.Index.NO;
        }
        if ("not_analyzed".equals(index)) {
            return Field.Index.NOT_ANALYZED;
        }
        if ("analyzed".equals(index)) {
            return Field.Index.ANALYZED;
        }
        throw new MapperParsingException("Wrong value for index [" + index + "] for field [" + fieldName + "]");
    }

    public static Field.Store parseStore(String fieldName, String store) throws MapperParsingException {
        if ("no".equals(store)) {
            return Field.Store.NO;
        }
        if ("yes".equals(store)) {
            return Field.Store.YES;
        }
        boolean value = XContentMapValues.nodeBooleanValue(store);
        if (value) {
            return Field.Store.YES;
        }
        return Field.Store.NO;
    }

    public static ContentPath.Type parsePathType(String name, String path) throws MapperParsingException {
        if ("just_name".equals(path = Strings.toUnderscoreCase(path))) {
            return ContentPath.Type.JUST_NAME;
        }
        if ("full".equals(path)) {
            return ContentPath.Type.FULL;
        }
        throw new MapperParsingException("Wrong value for pathType [" + path + "] for objet [" + name + "]");
    }
}

