/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.OrFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentFilterParser;
import org.elasticsearch.index.settings.IndexSettings;

public class OrFilterParser
extends AbstractIndexComponent
implements XContentFilterParser {
    public static final String NAME = "or";

    @Inject
    public OrFilterParser(Index index, @IndexSettings Settings settings) {
        super(index, settings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        ArrayList<Filter> filters = Lists.newArrayList();
        boolean cache = false;
        String filterName = null;
        String currentFieldName = null;
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                filters.add(parseContext.parseInnerFilter());
            }
        } else {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if ("filters".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            filters.add(parseContext.parseInnerFilter());
                        }
                        continue;
                    }
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        filters.add(parseContext.parseInnerFilter());
                    }
                    continue;
                }
                if (!token.isValue()) continue;
                if ("_cache".equals(currentFieldName)) {
                    cache = parser.booleanValue();
                    continue;
                }
                if (!"_name".equals(currentFieldName)) continue;
                filterName = parser.text();
            }
        }
        if (filters.isEmpty()) {
            throw new QueryParsingException(this.index, "[or] filter requires 'filters' to be set on it'");
        }
        Filter filter = new OrFilter(filters);
        if (cache) {
            filter = parseContext.cacheFilter(filter);
        }
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

