/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.jmx.action;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StringStreamable;
import org.elasticsearch.common.io.stream.VoidStreamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.jmx.JmxService;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.FutureTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;

public class GetJmxServiceUrlAction
extends AbstractComponent {
    private final JmxService jmxService;
    private final TransportService transportService;
    private final ClusterService clusterService;

    @Inject
    public GetJmxServiceUrlAction(Settings settings, JmxService jmxService, TransportService transportService, ClusterService clusterService) {
        super(settings);
        this.jmxService = jmxService;
        this.transportService = transportService;
        this.clusterService = clusterService;
        transportService.registerHandler("jmx/publishUrl", new GetJmxServiceUrlTransportHandler());
    }

    public String obtainPublishUrl(DiscoveryNode node) throws ElasticSearchException {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            return this.jmxService.publishUrl();
        }
        return this.transportService.submitRequest(node, "jmx/publishUrl", VoidStreamable.INSTANCE, new FutureTransportResponseHandler<StringStreamable>(){

            @Override
            public StringStreamable newInstance() {
                return new StringStreamable();
            }
        }).txGet().get();
    }

    private class GetJmxServiceUrlTransportHandler
    extends BaseTransportRequestHandler<VoidStreamable> {
        static final String ACTION = "jmx/publishUrl";

        private GetJmxServiceUrlTransportHandler() {
        }

        @Override
        public VoidStreamable newInstance() {
            return VoidStreamable.INSTANCE;
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(VoidStreamable request, TransportChannel channel) throws Exception {
            channel.sendResponse(new StringStreamable(GetJmxServiceUrlAction.this.jmxService.publishUrl()));
        }
    }
}

