/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.Modules;
import org.elasticsearch.common.inject.PreProcessModule;
import org.elasticsearch.common.inject.SpawnModules;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.PluginsService;

public class ShardsPluginsModule
extends AbstractModule
implements SpawnModules,
PreProcessModule {
    private final Settings settings;
    private final PluginsService pluginsService;

    public ShardsPluginsModule(Settings settings, PluginsService pluginsService) {
        this.settings = settings;
        this.pluginsService = pluginsService;
    }

    @Override
    public Iterable<? extends Module> spawnModules() {
        ArrayList<Module> modules = Lists.newArrayList();
        Collection<Class<? extends Module>> modulesClasses = this.pluginsService.shardModules();
        for (Class<? extends Module> moduleClass : modulesClasses) {
            modules.add(Modules.createModule(moduleClass, this.settings));
        }
        return modules;
    }

    @Override
    public void processModule(Module module) {
        this.pluginsService.processModule(module);
    }

    @Override
    protected void configure() {
    }
}

