/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.main;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Classes;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.jsr166y.ThreadLocalRandom;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.StringRestResponse;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestMainAction
extends BaseRestHandler {
    private final Map<String, Object> rootNode;
    private final int quotesSize;

    @Inject
    public RestMainAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        int quotesSize;
        Map<String, Object> rootNode;
        try {
            XContentParser parser = XContentFactory.xContent(XContentType.JSON).createParser(Classes.getDefaultClassLoader().getResourceAsStream("org/elasticsearch/rest/action/main/quotes.json"));
            rootNode = parser.map();
            List arrayNode = (List)rootNode.get("quotes");
            quotesSize = arrayNode.size();
        }
        catch (Exception e) {
            rootNode = null;
            quotesSize = -1;
        }
        this.rootNode = rootNode;
        this.quotesSize = quotesSize;
        controller.registerHandler(RestRequest.Method.GET, "/", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel) {
        try {
            if (request.method() == RestRequest.Method.HEAD) {
                channel.sendResponse(new StringRestResponse(RestStatus.OK));
                return;
            }
            XContentBuilder builder = RestXContentBuilder.restContentBuilder(request).prettyPrint();
            builder.startObject();
            builder.field("ok", true);
            if (this.settings.get("name") != null) {
                builder.field("name", this.settings.get("name"));
            }
            builder.startObject("version").field("number", Version.number()).field("date", Version.date()).field("snapshot_build", Version.snapshotBuild()).endObject();
            builder.field("tagline", "You Know, for Search");
            builder.field("cover", "DON'T PANIC");
            if (this.rootNode != null) {
                builder.startObject("quote");
                List arrayNode = (List)this.rootNode.get("quotes");
                Map quoteNode = (Map)arrayNode.get(ThreadLocalRandom.current().nextInt(this.quotesSize));
                builder.field("book", quoteNode.get("book").toString());
                builder.field("chapter", quoteNode.get("chapter").toString());
                List textNodes = (List)quoteNode.get("text");
                int index = 0;
                for (Object textNode : textNodes) {
                    builder.field("text" + ++index, textNode.toString());
                }
                builder.endObject();
            }
            builder.endObject();
            channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
        }
        catch (Exception e) {
            try {
                channel.sendResponse(new XContentThrowableRestResponse(request, e));
            }
            catch (IOException e1) {
                this.logger.warn("Failed to send response", e, new Object[0]);
            }
        }
    }
}

