/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.joda.time.MutableDateTime;
import org.elasticsearch.common.trove.map.hash.TLongLongHashMap;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.longs.LongFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.InternalCountDateHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class CountDateHistogramFacetCollector
extends AbstractFacetCollector {
    private final String indexFieldName;
    private final MutableDateTime dateTime;
    private final DateHistogramFacet.ComparatorType comparatorType;
    private final FieldDataCache fieldDataCache;
    private final FieldDataType fieldDataType;
    private LongFieldData fieldData;
    private final DateHistogramProc histoProc;

    public CountDateHistogramFacetCollector(String facetName, String fieldName, MutableDateTime dateTime, long interval, DateHistogramFacet.ComparatorType comparatorType, SearchContext context) {
        super(facetName);
        this.dateTime = dateTime;
        this.comparatorType = comparatorType;
        this.fieldDataCache = context.fieldDataCache();
        MapperService.SmartNameFieldMappers smartMappers = context.mapperService().smartName(fieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + fieldName + "]");
        }
        if (smartMappers.hasDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        FieldMapper mapper = smartMappers.mapper();
        this.indexFieldName = mapper.names().indexName();
        this.fieldDataType = mapper.fieldDataType();
        this.histoProc = interval == 1L ? new DateHistogramProc() : new IntervalDateHistogramProc(interval);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.fieldData.forEachValueInDoc(doc, this.dateTime, this.histoProc);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.fieldData = (LongFieldData)this.fieldDataCache.cache(this.fieldDataType, reader, this.indexFieldName);
    }

    @Override
    public Facet facet() {
        return new InternalCountDateHistogramFacet(this.facetName, this.comparatorType, this.histoProc.counts(), true);
    }

    public static long bucket(long value, long interval) {
        return value / interval * interval;
    }

    public static class IntervalDateHistogramProc
    extends DateHistogramProc {
        private final long interval;

        public IntervalDateHistogramProc(long interval) {
            this.interval = interval;
        }

        @Override
        public void onValue(int docId, MutableDateTime dateTime) {
            long bucket = CountDateHistogramFacetCollector.bucket(dateTime.getMillis(), this.interval);
            this.counts.adjustOrPutValue(bucket, 1L, 1L);
        }
    }

    public static class DateHistogramProc
    implements LongFieldData.DateValueInDocProc {
        protected final TLongLongHashMap counts = CacheRecycler.popLongLongMap();

        @Override
        public void onValue(int docId, MutableDateTime dateTime) {
            this.counts.adjustOrPutValue(dateTime.getMillis(), 1L, 1L);
        }

        public TLongLongHashMap counts() {
            return this.counts;
        }
    }
}

