/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.filter;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.DocSets;
import org.elasticsearch.index.cache.filter.FilterCache;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.filter.InternalFilterFacet;

public class FilterFacetCollector
extends AbstractFacetCollector {
    private final Filter filter;
    private DocSet docSet;
    private int count = 0;

    public FilterFacetCollector(String facetName, Filter filter, FilterCache filterCache) {
        super(facetName);
        this.filter = filter;
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.docSet = DocSets.convert(reader, this.filter.getDocIdSet(reader));
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        if (this.docSet.get(doc)) {
            ++this.count;
        }
    }

    @Override
    public Facet facet() {
        return new InternalFilterFacet(this.facetName, this.count);
    }
}

