/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.geodistance;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPointFieldData;
import org.elasticsearch.index.search.geo.GeoDistance;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacet;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacetCollector;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptGeoDistanceFacetCollector
extends GeoDistanceFacetCollector {
    private final SearchScript script;
    private Aggregator scriptAggregator;

    public ScriptGeoDistanceFacetCollector(String facetName, String fieldName, double lat, double lon, DistanceUnit unit, GeoDistance geoDistance, GeoDistanceFacet.Entry[] entries, SearchContext context, String scriptLang, String script, Map<String, Object> params) {
        super(facetName, fieldName, lat, lon, unit, geoDistance, entries, context);
        this.script = context.scriptService().search(context.lookup(), scriptLang, script, params);
        this.aggregator = new Aggregator(lat, lon, geoDistance, unit, entries);
        this.scriptAggregator = (Aggregator)this.aggregator;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.script.setScorer(scorer);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        super.doSetNextReader(reader, docBase);
        this.script.setNextReader(reader);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.script.setNextDocId(doc);
        this.scriptAggregator.scriptValue = this.script.runAsDouble();
        super.doCollect(doc);
    }

    public static class Aggregator
    implements GeoPointFieldData.ValueInDocProc {
        protected final double lat;
        protected final double lon;
        private final GeoDistance geoDistance;
        private final DistanceUnit unit;
        private final GeoDistanceFacet.Entry[] entries;
        double scriptValue;

        public Aggregator(double lat, double lon, GeoDistance geoDistance, DistanceUnit unit, GeoDistanceFacet.Entry[] entries) {
            this.lat = lat;
            this.lon = lon;
            this.geoDistance = geoDistance;
            this.unit = unit;
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, double lat, double lon) {
            double distance = this.geoDistance.calculate(this.lat, this.lon, lat, lon, this.unit);
            for (GeoDistanceFacet.Entry entry : this.entries) {
                if (entry.foundInDoc || !(distance >= entry.getFrom()) || !(distance < entry.getTo())) continue;
                entry.foundInDoc = true;
                ++entry.count;
                ++entry.totalCount;
                entry.total += this.scriptValue;
                if (this.scriptValue < entry.min) {
                    entry.min = this.scriptValue;
                }
                if (!(this.scriptValue > entry.max)) continue;
                entry.max = this.scriptValue;
            }
        }
    }
}

