/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram.unbounded;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.trove.ExtTLongObjectHashMap;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.unbounded.FullHistogramFacetCollector;
import org.elasticsearch.search.facet.histogram.unbounded.InternalFullHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class ValueHistogramFacetCollector
extends AbstractFacetCollector {
    private final String keyIndexFieldName;
    private final String valueIndexFieldName;
    private final long interval;
    private final HistogramFacet.ComparatorType comparatorType;
    private final FieldDataCache fieldDataCache;
    private final FieldDataType keyFieldDataType;
    private NumericFieldData keyFieldData;
    private final FieldDataType valueFieldDataType;
    private final HistogramProc histoProc;

    public ValueHistogramFacetCollector(String facetName, String keyFieldName, String valueFieldName, long interval, HistogramFacet.ComparatorType comparatorType, SearchContext context) {
        super(facetName);
        this.interval = interval;
        this.comparatorType = comparatorType;
        this.fieldDataCache = context.fieldDataCache();
        MapperService.SmartNameFieldMappers smartMappers = context.mapperService().smartName(keyFieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + keyFieldName + "]");
        }
        if (smartMappers.hasDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        this.keyIndexFieldName = smartMappers.mapper().names().indexName();
        this.keyFieldDataType = smartMappers.mapper().fieldDataType();
        FieldMapper mapper = context.mapperService().smartNameFieldMapper(valueFieldName);
        if (mapper == null) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for value_field [" + valueFieldName + "]");
        }
        this.valueIndexFieldName = mapper.names().indexName();
        this.valueFieldDataType = mapper.fieldDataType();
        this.histoProc = new HistogramProc(interval);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.keyFieldData.forEachValueInDoc(doc, this.histoProc);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.keyFieldData = (NumericFieldData)this.fieldDataCache.cache(this.keyFieldDataType, reader, this.keyIndexFieldName);
        this.histoProc.valueFieldData = (NumericFieldData)this.fieldDataCache.cache(this.valueFieldDataType, reader, this.valueIndexFieldName);
    }

    @Override
    public Facet facet() {
        return new InternalFullHistogramFacet(this.facetName, this.comparatorType, this.histoProc.entries, true);
    }

    public static class HistogramProc
    implements NumericFieldData.DoubleValueInDocProc {
        final long interval;
        final ExtTLongObjectHashMap<InternalFullHistogramFacet.FullEntry> entries = CacheRecycler.popLongObjectMap();
        NumericFieldData valueFieldData;
        final ValueAggregator valueAggregator = new ValueAggregator();

        public HistogramProc(long interval) {
            this.interval = interval;
        }

        @Override
        public void onValue(int docId, double value) {
            long bucket = FullHistogramFacetCollector.bucket(value, this.interval);
            InternalFullHistogramFacet.FullEntry entry = (InternalFullHistogramFacet.FullEntry)this.entries.get(bucket);
            if (entry == null) {
                entry = new InternalFullHistogramFacet.FullEntry(bucket, 0L, Double.MAX_VALUE, Double.MIN_VALUE, 0L, 0.0);
                this.entries.put(bucket, entry);
            }
            ++entry.count;
            this.valueAggregator.entry = entry;
            this.valueFieldData.forEachValueInDoc(docId, this.valueAggregator);
        }

        public static class ValueAggregator
        implements NumericFieldData.DoubleValueInDocProc {
            InternalFullHistogramFacet.FullEntry entry;

            @Override
            public void onValue(int docId, double value) {
                ++this.entry.totalCount;
                this.entry.total += value;
                if (value < this.entry.min) {
                    this.entry.min = value;
                }
                if (value > this.entry.max) {
                    this.entry.max = value;
                }
            }
        }
    }
}

