/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.SearchHitPhase;
import org.elasticsearch.search.fetch.script.ScriptFieldsContext;
import org.elasticsearch.search.fetch.script.ScriptFieldsParseElement;
import org.elasticsearch.search.internal.InternalSearchHitField;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptFieldsSearchHitPhase
implements SearchHitPhase {
    @Inject
    public ScriptFieldsSearchHitPhase() {
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        ImmutableMap.Builder<String, ScriptFieldsParseElement> parseElements = ImmutableMap.builder();
        parseElements.put("script_fields", new ScriptFieldsParseElement()).put("scriptFields", new ScriptFieldsParseElement());
        return parseElements.build();
    }

    @Override
    public boolean executionNeeded(SearchContext context) {
        return context.hasScriptFields();
    }

    @Override
    public void execute(SearchContext context, SearchHitPhase.HitContext hitContext) throws ElasticSearchException {
        for (ScriptFieldsContext.ScriptField scriptField : context.scriptFields().fields()) {
            SearchHitField hitField;
            Object value;
            scriptField.script().setNextReader(hitContext.reader());
            scriptField.script().setNextDocId(hitContext.docId());
            try {
                value = scriptField.script().run();
            }
            catch (RuntimeException e) {
                if (scriptField.ignoreException()) continue;
                throw e;
            }
            if (hitContext.hit().fieldsOrNull() == null) {
                hitContext.hit().fields(new HashMap<String, SearchHitField>(2));
            }
            if ((hitField = hitContext.hit().fields().get(scriptField.name())) == null) {
                hitField = new InternalSearchHitField(scriptField.name(), new ArrayList<Object>(2));
                hitContext.hit().fields().put(scriptField.name(), hitField);
            }
            hitField.values().add(value);
        }
    }
}

