/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.jsse;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.camel.util.jsse.BaseSSLContextParameters;
import org.apache.camel.util.jsse.KeyManagersParameters;
import org.apache.camel.util.jsse.SSLContextClientParameters;
import org.apache.camel.util.jsse.SSLContextServerParameters;
import org.apache.camel.util.jsse.SecureRandomParameters;
import org.apache.camel.util.jsse.TrustManagersParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLContextParameters
extends BaseSSLContextParameters {
    protected static final String DEFAULT_SECURE_SOCKET_PROTOCOL = "TLS";
    private static final Logger LOG = LoggerFactory.getLogger(SSLContextParameters.class);
    private KeyManagersParameters keyManagers;
    private TrustManagersParameters trustManagers;
    private SecureRandomParameters secureRandom;
    private SSLContextClientParameters clientParameters;
    private SSLContextServerParameters serverParameters;
    private String provider;
    private String secureSocketProtocol;

    public KeyManagersParameters getKeyManagers() {
        return this.keyManagers;
    }

    public void setKeyManagers(KeyManagersParameters keyManagers) {
        this.keyManagers = keyManagers;
    }

    public TrustManagersParameters getTrustManagers() {
        return this.trustManagers;
    }

    public void setTrustManagers(TrustManagersParameters trustManagers) {
        this.trustManagers = trustManagers;
    }

    public SecureRandomParameters getSecureRandom() {
        return this.secureRandom;
    }

    public void setSecureRandom(SecureRandomParameters secureRandom) {
        this.secureRandom = secureRandom;
    }

    public SSLContextClientParameters getClientParameters() {
        return this.clientParameters;
    }

    public void setClientParameters(SSLContextClientParameters clientParameters) {
        this.clientParameters = clientParameters;
    }

    public SSLContextServerParameters getServerParameters() {
        return this.serverParameters;
    }

    public void setServerParameters(SSLContextServerParameters serverParameters) {
        this.serverParameters = serverParameters;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getSecureSocketProtocol() {
        if (this.secureSocketProtocol == null) {
            return DEFAULT_SECURE_SOCKET_PROTOCOL;
        }
        return this.secureSocketProtocol;
    }

    public void setSecureSocketProtocol(String secureSocketProtocol) {
        this.secureSocketProtocol = secureSocketProtocol;
    }

    public SSLContext createSSLContext() throws GeneralSecurityException, IOException {
        LOG.debug("Creating SSLContext from SSLContextParameters: {}", (Object)this);
        KeyManager[] keyManagers = this.keyManagers == null ? null : this.keyManagers.createKeyManagers();
        TrustManager[] trustManagers = this.trustManagers == null ? null : this.trustManagers.createTrustManagers();
        SecureRandom secureRandom = this.secureRandom == null ? null : this.secureRandom.createSecureRandom();
        SSLContext context = this.getProvider() == null ? SSLContext.getInstance(this.parsePropertyValue(this.getSecureSocketProtocol())) : SSLContext.getInstance(this.parsePropertyValue(this.getSecureSocketProtocol()), this.parsePropertyValue(this.getProvider()));
        context.init(keyManagers, trustManagers, secureRandom);
        this.configureSSLContext(context);
        context = new BaseSSLContextParameters.SSLContextDecorator(new BaseSSLContextParameters.SSLContextSpiDecorator(context, this.getSSLEngineConfigurers(context), this.getSSLSocketFactoryConfigurers(context), this.getSSLServerSocketFactoryConfigurers(context)));
        return context;
    }

    @Override
    protected void configureSSLContext(SSLContext context) throws GeneralSecurityException {
        LOG.trace("Configuring client and server side SSLContext parameters...");
        super.configureSSLContext(context);
        if (this.getClientParameters() != null) {
            LOG.debug("Overriding client-side SSLContext parameters with configured client parameters.");
            this.getClientParameters().configureSSLContext(context);
        }
        if (this.getServerParameters() != null) {
            LOG.debug("Overriding server-side SSLContext parameters with configured server parameters.");
            this.getServerParameters().configureSSLContext(context);
        }
        LOG.trace("Configured client and server side SSLContext parameters.");
    }

    @Override
    protected List<BaseSSLContextParameters.Configurer<SSLEngine>> getSSLEngineConfigurers(SSLContext context) {
        LOG.trace("Collecting client and server side SSLEngine configurers...");
        List<BaseSSLContextParameters.Configurer<SSLEngine>> configurers = super.getSSLEngineConfigurers(context);
        if (this.getClientParameters() != null) {
            LOG.debug("Augmenting SSLEngine configurers with configurers from client parameters.");
            configurers.addAll(this.getClientParameters().getSSLEngineConfigurers(context));
        }
        if (this.getServerParameters() != null) {
            LOG.debug("Augmenting SSLEngine configurers with configurers from server parameters.");
            configurers.addAll(this.getServerParameters().getSSLEngineConfigurers(context));
        }
        LOG.trace("Collected client and server side SSLEngine configurers.");
        return configurers;
    }

    @Override
    protected List<BaseSSLContextParameters.Configurer<SSLSocketFactory>> getSSLSocketFactoryConfigurers(SSLContext context) {
        LOG.trace("Collecting SSLSocketFactory configurers...");
        List<BaseSSLContextParameters.Configurer<SSLSocketFactory>> configurers = super.getSSLSocketFactoryConfigurers(context);
        if (this.getClientParameters() != null) {
            LOG.debug("Augmenting SSLSocketFactory configurers with configurers from client parameters.");
            configurers.addAll(this.getClientParameters().getSSLSocketFactoryConfigurers(context));
        }
        LOG.trace("Collected SSLSocketFactory configurers.");
        return configurers;
    }

    @Override
    protected List<BaseSSLContextParameters.Configurer<SSLServerSocketFactory>> getSSLServerSocketFactoryConfigurers(SSLContext context) {
        LOG.trace("Collecting SSLServerSocketFactory configurers...");
        List<BaseSSLContextParameters.Configurer<SSLServerSocketFactory>> configurers = super.getSSLServerSocketFactoryConfigurers(context);
        if (this.getServerParameters() != null) {
            LOG.debug("Augmenting SSLServerSocketFactory configurers with configurers from server parameters.");
            configurers.addAll(this.getServerParameters().getSSLServerSocketFactoryConfigurers(context));
        }
        LOG.trace("Collected client and server side SSLServerSocketFactory configurers.");
        return configurers;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SSLContextParameters [keyManagers=");
        builder.append(this.keyManagers);
        builder.append(", trustManagers=");
        builder.append(this.trustManagers);
        builder.append(", secureRandom=");
        builder.append(this.secureRandom);
        builder.append(", clientParameters=");
        builder.append(this.clientParameters);
        builder.append(", serverParameters=");
        builder.append(this.serverParameters);
        builder.append(", provider=");
        builder.append(this.provider);
        builder.append(", secureSocketProtocol=");
        builder.append(this.secureSocketProtocol);
        builder.append(", getCipherSuites()=");
        builder.append(this.getCipherSuites());
        builder.append(", getCipherSuitesFilter()=");
        builder.append(this.getCipherSuitesFilter());
        builder.append(", getSecureSocketProtocols()=");
        builder.append(this.getSecureSocketProtocols());
        builder.append(", getSecureSocketProtocolsFilter()=");
        builder.append(this.getSecureSocketProtocolsFilter());
        builder.append(", getSessionTimeout()=");
        builder.append(this.getSessionTimeout());
        builder.append(", getContext()=");
        builder.append(this.getCamelContext());
        builder.append("]");
        return builder.toString();
    }
}

