/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.jaas;

import java.util.Map;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.BackingEngineFactory;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.jaas.BasicEncryptionSupport;
import org.fusesource.fabric.jaas.ZookeeperBackingEngine;
import org.fusesource.fabric.jaas.ZookeeperLoginModule;
import org.fusesource.fabric.jaas.ZookeeperProperties;
import org.fusesource.fabric.service.FabricServiceImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperBackingEngineFactory
implements BackingEngineFactory {
    protected BundleContext bundleContext;
    protected FabricService service;
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ZookeeperBackingEngineFactory.class);

    public String getModuleClass() {
        return ZookeeperLoginModule.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackingEngine build(Map options) {
        String path;
        ZookeeperBackingEngine engine = null;
        this.bundleContext = (BundleContext)options.get(BundleContext.class.getName());
        BasicEncryptionSupport encryptionSupport = new BasicEncryptionSupport(options);
        if (this.bundleContext != null) {
            ServiceReference ref = this.bundleContext.getServiceReference(FabricService.class.getName());
            this.service = (FabricServiceImpl)this.bundleContext.getService(ref);
            encryptionSupport = new EncryptionSupport(options);
        }
        if ((path = (String)options.get("path")) == null) {
            path = "fabric/authentication/users";
        }
        try {
            ZookeeperProperties users = new ZookeeperProperties(((FabricServiceImpl)this.service).getZooKeeper(), path);
            engine = new ZookeeperBackingEngine(users, encryptionSupport);
            return engine;
        }
        catch (Exception e) {
            LOGGER.warn("Cannot initialize engine", (Throwable)e);
        }
        finally {
            return engine;
        }
    }

    public void setService(FabricService service) {
        this.service = service;
    }
}

