/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.dosgi.capset;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.fusesource.fabric.dosgi.capset.Attribute;
import org.fusesource.fabric.dosgi.capset.Capability;
import org.fusesource.fabric.dosgi.capset.SimpleFilter;

public class CapabilitySet<C extends Capability> {
    private final Map<String, Map<Object, Set<C>>> m_indices;
    private final Set<C> m_capSet = new HashSet<C>();
    private final ReadWriteLock m_lock = new ReentrantReadWriteLock();
    private static final Class[] STRING_CLASS = new Class[]{String.class};

    public CapabilitySet(List<String> indexProps, boolean caseSensitive) {
        this.m_indices = caseSensitive ? new TreeMap<String, Map<Object, Set<C>>>() : new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; indexProps != null && i < indexProps.size(); ++i) {
            this.m_indices.put(indexProps.get(i), new HashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCapability(C cap) {
        this.m_lock.writeLock().lock();
        try {
            this.doAddCapability(cap);
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    private void doAddCapability(C cap) {
        this.m_capSet.add(cap);
        for (Map.Entry<String, Map<Object, Set<C>>> entry : this.m_indices.entrySet()) {
            Attribute capAttr = cap.getAttribute(entry.getKey());
            if (capAttr == null) continue;
            Object capValue = capAttr.getValue();
            if (capValue.getClass().isArray()) {
                capValue = CapabilitySet.convertArrayToList(capValue);
            }
            Map<Object, Set<C>> index = entry.getValue();
            if (capValue instanceof Collection) {
                Collection c = (Collection)capValue;
                for (Object o : c) {
                    this.indexCapability(index, cap, o);
                }
                continue;
            }
            this.indexCapability(index, cap, capValue);
        }
    }

    private void indexCapability(Map<Object, Set<C>> index, C cap, Object capValue) {
        Set<C> caps = index.get(capValue);
        if (caps == null) {
            caps = new HashSet<C>();
            index.put(capValue, caps);
        }
        caps.add(cap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCapability(C cap) {
        this.m_lock.writeLock().lock();
        try {
            this.doRemoveCapability(cap);
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    private void doRemoveCapability(C cap) {
        if (this.m_capSet.remove(cap)) {
            for (Map.Entry<String, Map<Object, Set<C>>> entry : this.m_indices.entrySet()) {
                Attribute capAttr = cap.getAttribute(entry.getKey());
                if (capAttr == null) continue;
                Object capValue = capAttr.getValue();
                if (capValue.getClass().isArray()) {
                    capValue = CapabilitySet.convertArrayToList(capValue);
                }
                Map<Object, Set<C>> index = entry.getValue();
                if (capValue instanceof Collection) {
                    Collection c = (Collection)capValue;
                    for (Object o : c) {
                        this.deindexCapability(index, cap, o);
                    }
                    continue;
                }
                this.deindexCapability(index, cap, capValue);
            }
        }
    }

    private void deindexCapability(Map<Object, Set<C>> index, C cap, Object capValue) {
        Set<C> caps = index.get(capValue);
        if (caps != null) {
            caps.remove(cap);
            if (caps.isEmpty()) {
                index.remove(capValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<C> match(SimpleFilter sf) {
        this.m_lock.readLock().lock();
        try {
            Set<C> set = this.match(this.m_capSet, sf);
            return set;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    private Set<C> match(Set<C> caps, SimpleFilter sf) {
        Set<Object> matches;
        block5: {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                matches = new HashSet<C>();
                                if (sf.getOperation() != 0) break block4;
                                matches.addAll(caps);
                                break block5;
                            }
                            if (sf.getOperation() != 1) break block6;
                            List sfs = (List)sf.getValue();
                            for (int i = 0; caps.size() > 0 && i < sfs.size(); ++i) {
                                matches = this.match(caps, (SimpleFilter)sfs.get(i));
                                caps = matches;
                            }
                            break block5;
                        }
                        if (sf.getOperation() != 2) break block7;
                        List sfs = (List)sf.getValue();
                        for (int i = 0; i < sfs.size(); ++i) {
                            matches.addAll(this.match(caps, (SimpleFilter)sfs.get(i)));
                        }
                        break block5;
                    }
                    if (sf.getOperation() != 3) break block8;
                    matches.addAll(caps);
                    List sfs = (List)sf.getValue();
                    for (int i = 0; i < sfs.size(); ++i) {
                        matches.removeAll(this.match(caps, (SimpleFilter)sfs.get(i)));
                    }
                    break block5;
                }
                Map<Object, Set<C>> index = this.m_indices.get(sf.getName());
                if (sf.getOperation() != 4 || index == null) break block9;
                Set<C> existingCaps = index.get(sf.getValue());
                if (existingCaps == null) break block5;
                matches.addAll(existingCaps);
                matches.retainAll(caps);
                break block5;
            }
            for (Capability cap : caps) {
                Object lhs;
                Attribute attr = cap.getAttribute(sf.getName());
                if (attr == null || !CapabilitySet.compare(lhs = attr.getValue(), sf.getValue(), sf.getOperation())) continue;
                matches.add(cap);
            }
        }
        return matches;
    }

    public static boolean matches(Capability cap, SimpleFilter sf) {
        return CapabilitySet.matchesInternal(cap, sf);
    }

    private static boolean matchesInternal(Capability cap, SimpleFilter sf) {
        boolean matched = true;
        if (sf.getOperation() == 1) {
            List sfs = (List)sf.getValue();
            for (int i = 0; matched && i < sfs.size(); ++i) {
                matched = CapabilitySet.matchesInternal(cap, (SimpleFilter)sfs.get(i));
            }
        } else if (sf.getOperation() == 2) {
            matched = false;
            List sfs = (List)sf.getValue();
            for (int i = 0; !matched && i < sfs.size(); ++i) {
                matched = CapabilitySet.matchesInternal(cap, (SimpleFilter)sfs.get(i));
            }
        } else if (sf.getOperation() == 3) {
            List sfs = (List)sf.getValue();
            for (int i = 0; i < sfs.size(); ++i) {
                matched = !CapabilitySet.matchesInternal(cap, (SimpleFilter)sfs.get(i));
            }
        } else {
            matched = false;
            Attribute attr = cap.getAttribute(sf.getName());
            if (attr != null) {
                Object lhs = attr.getValue();
                matched = CapabilitySet.compare(lhs, sf.getValue(), sf.getOperation());
            }
        }
        return matched;
    }

    private static boolean compare(Object lhs, Object rhsUnknown, int op) {
        if (op == 8) {
            return true;
        }
        if (lhs instanceof Comparable) {
            Object rhs;
            if (op == 7 && !(lhs instanceof String)) {
                return false;
            }
            if (op == 7) {
                rhs = rhsUnknown;
            } else {
                try {
                    rhs = CapabilitySet.coerceType(lhs, (String)rhsUnknown);
                }
                catch (Exception ex) {
                    return false;
                }
            }
            switch (op) {
                case 4: {
                    return ((Comparable)lhs).compareTo(rhs) == 0;
                }
                case 6: {
                    return ((Comparable)lhs).compareTo(rhs) >= 0;
                }
                case 5: {
                    return ((Comparable)lhs).compareTo(rhs) <= 0;
                }
                case 9: {
                    return CapabilitySet.compareApproximate((Comparable)lhs, rhs);
                }
                case 7: {
                    return SimpleFilter.compareSubstring((List)rhs, (String)lhs);
                }
            }
            throw new RuntimeException("Unknown comparison operator: " + op);
        }
        if (lhs instanceof Boolean) {
            Object rhs;
            try {
                rhs = CapabilitySet.coerceType(lhs, (String)rhsUnknown);
            }
            catch (Exception ex) {
                return false;
            }
            switch (op) {
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    return lhs.equals(rhs);
                }
            }
            throw new RuntimeException("Unknown comparison operator: " + op);
        }
        if (lhs.getClass().isArray()) {
            lhs = CapabilitySet.convertArrayToList(lhs);
        }
        if (lhs instanceof Collection) {
            Iterator iter = ((Collection)lhs).iterator();
            while (iter.hasNext()) {
                if (!CapabilitySet.compare(iter.next(), rhsUnknown, op)) continue;
                return true;
            }
            return false;
        }
        if (op == 7 && !(lhs instanceof String)) {
            return false;
        }
        Object rhsObj = null;
        try {
            rhsObj = CapabilitySet.coerceType(lhs, (String)rhsUnknown);
        }
        catch (Exception ex) {
            return false;
        }
        return lhs.equals(rhsObj);
    }

    private static boolean compareApproximate(Object lhs, Object rhs) {
        if (rhs instanceof String) {
            return CapabilitySet.removeWhitespace((String)lhs).equalsIgnoreCase(CapabilitySet.removeWhitespace((String)rhs));
        }
        if (rhs instanceof Character) {
            return Character.toLowerCase(((Character)lhs).charValue()) == Character.toLowerCase(((Character)rhs).charValue());
        }
        return lhs.equals(rhs);
    }

    private static String removeWhitespace(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    private static Object coerceType(Object lhs, String rhsString) throws Exception {
        Character rhs;
        if (lhs.getClass() == rhsString.getClass()) {
            return rhsString;
        }
        try {
            if (lhs instanceof Character) {
                rhs = Character.valueOf(rhsString.charAt(0));
            } else {
                Constructor<?> ctor = lhs.getClass().getConstructor(STRING_CLASS);
                ctor.setAccessible(true);
                rhs = ctor.newInstance(rhsString);
            }
        }
        catch (Exception ex) {
            throw new Exception("Could not instantiate class " + lhs.getClass().getName() + " from string constructor with argument '" + rhsString + "' because " + ex);
        }
        return rhs;
    }

    private static List convertArrayToList(Object array) {
        int len = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }
}

