/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi.commands.module;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.fab.ModuleRegistry;
import org.fusesource.fabric.fab.VersionedDependencyId;
import org.fusesource.fabric.fab.osgi.commands.CommandSupport;
import org.fusesource.fabric.fab.osgi.internal.Activator;
import org.fusesource.fabric.fab.osgi.internal.OsgiModuleRegistry;
import org.fusesource.fabric.fab.util.Strings;
import org.osgi.framework.Bundle;

@Command(name="list", scope="module", description="List the installed modules")
public class ListCommand
extends CommandSupport {
    @Argument(index=0, required=false, description="Name of the module to list")
    private String name;

    protected Object doExecute() throws Exception {
        OsgiModuleRegistry registry = Activator.registry;
        List<ModuleRegistry.Module> modules = registry.getApplicationModules();
        Map<VersionedDependencyId, Bundle> installed = registry.getInstalled();
        CommandSupport.Table table = new CommandSupport.Table("{1} | {2} | {3} | {4}", 3, -20, -10, -40);
        table.add("Id", "Name", "Version", "Description");
        for (ModuleRegistry.Module module : modules) {
            ModuleRegistry.VersionedModule latest = module.latest();
            HashSet<VersionedDependencyId> s = new HashSet<VersionedDependencyId>(module.getVersionIds());
            s.retainAll(installed.keySet());
            if (s.isEmpty() || this.name != null && module.getName().indexOf(this.name) < 0) continue;
            HashSet<Long> bundles = new HashSet<Long>();
            for (VersionedDependencyId dependencyId : s) {
                bundles.add(installed.get(dependencyId).getBundleId());
            }
            table.add(Strings.join(bundles, ", "), module.getName(), latest.getId().getVersion(), latest.getDescription());
        }
        table.print(this.session.getConsole());
        return null;
    }
}

