/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.processor.RedeliveryErrorHandler;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;
import org.apache.camel.spring.spi.TransactionRollbackException;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionErrorHandler
extends RedeliveryErrorHandler {
    private final TransactionTemplate transactionTemplate;
    private final String transactionKey;
    private final LoggingLevel rollbackLoggingLevel;

    public TransactionErrorHandler(CamelContext camelContext, Processor output, CamelLogger logger, Processor redeliveryProcessor, RedeliveryPolicy redeliveryPolicy, ExceptionPolicyStrategy exceptionPolicyStrategy, TransactionTemplate transactionTemplate, Predicate retryWhile, ScheduledExecutorService executorService, LoggingLevel rollbackLoggingLevel) {
        super(camelContext, output, logger, redeliveryProcessor, redeliveryPolicy, null, null, false, retryWhile, executorService);
        this.setExceptionPolicy(exceptionPolicyStrategy);
        this.transactionTemplate = transactionTemplate;
        this.rollbackLoggingLevel = rollbackLoggingLevel;
        this.transactionKey = ObjectHelper.getIdentityHashCode((Object)transactionTemplate);
    }

    public boolean supportTransacted() {
        return true;
    }

    public String toString() {
        if (this.output == null) {
            return "";
        }
        return "TransactionErrorHandler:" + TransactionErrorHandler.propagationBehaviorToString(this.transactionTemplate.getPropagationBehavior()) + "[" + this.getOutput() + "]";
    }

    public void process(Exchange exchange) throws Exception {
        if (exchange.getUnitOfWork().isTransactedBy((Object)this.transactionKey)) {
            this.processByErrorHandler(exchange);
        } else {
            this.processInTransaction(exchange);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.process(exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInTransaction(Exchange exchange) throws Exception {
        Boolean onlyLast;
        Boolean externalRedelivered = exchange.isExternalRedelivered();
        String redelivered = externalRedelivered != null ? externalRedelivered.toString() : "unknown";
        String ids = ExchangeHelper.logIds((Exchange)exchange);
        try {
            exchange.getUnitOfWork().beginTransactedBy((Object)this.transactionKey);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Transaction begin ({}) redelivered({}) for {})", new Object[]{this.transactionKey, redelivered, ids});
            }
            this.doInTransactionTemplate(exchange);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Transaction commit ({}) redelivered({}) for {})", new Object[]{this.transactionKey, redelivered, ids});
            }
        }
        catch (TransactionRollbackException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnly", new Object[]{this.transactionKey, redelivered, ids});
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
            this.logTransactionRollback(redelivered, ids, e);
        }
        finally {
            exchange.getUnitOfWork().endTransactedBy((Object)this.transactionKey);
        }
        if ((onlyLast = (Boolean)exchange.removeProperty("CamelRollbackOnlyLast")) != null && onlyLast.booleanValue()) {
            if (this.log.isDebugEnabled()) {
                Exception cause = exchange.getException();
                if (cause != null) {
                    this.log.debug("Transaction rollback (" + this.transactionKey + ") redelivered(" + redelivered + ") for " + ids + " due exchange was marked for rollbackOnlyLast and caught: ", (Throwable)cause);
                } else {
                    this.log.debug("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnlyLast", new Object[]{this.transactionKey, redelivered, ids});
                }
            }
            exchange.setException(null);
        }
    }

    protected void doInTransactionTemplate(final Exchange exchange) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                TransactionErrorHandler.this.processByErrorHandler(exchange);
                if (exchange.getException() != null || exchange.isRollbackOnly()) {
                    TransactionRollbackException rce = exchange.getException() != null ? ObjectHelper.wrapRuntimeCamelException((Throwable)exchange.getException()) : new TransactionRollbackException();
                    if (!status.isRollbackOnly()) {
                        status.setRollbackOnly();
                    }
                    throw rce;
                }
            }
        });
    }

    protected void processByErrorHandler(Exchange exchange) {
        super.process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
            }
        });
    }

    private void logTransactionRollback(String redelivered, String ids, Throwable e) {
        if (this.rollbackLoggingLevel == LoggingLevel.OFF) {
            return;
        }
        if (this.rollbackLoggingLevel == LoggingLevel.ERROR && this.log.isErrorEnabled()) {
            this.log.error("Transaction rollback ({}) redelivered({}) for {} caught: {}", new Object[]{this.transactionKey, redelivered, ids, e.getMessage()});
        } else if (this.rollbackLoggingLevel == LoggingLevel.WARN && this.log.isWarnEnabled()) {
            this.log.warn("Transaction rollback ({}) redelivered({}) for {} caught: {}", new Object[]{this.transactionKey, redelivered, ids, e.getMessage()});
        } else if (this.rollbackLoggingLevel == LoggingLevel.INFO && this.log.isInfoEnabled()) {
            this.log.info("Transaction rollback ({}) redelivered({}) for {} caught: {}", new Object[]{this.transactionKey, redelivered, ids, e.getMessage()});
        } else if (this.rollbackLoggingLevel == LoggingLevel.DEBUG && this.log.isDebugEnabled()) {
            this.log.debug("Transaction rollback ({}) redelivered({}) for {} caught: {}", new Object[]{this.transactionKey, redelivered, ids, e.getMessage()});
        } else if (this.rollbackLoggingLevel == LoggingLevel.TRACE && this.log.isTraceEnabled()) {
            this.log.trace("Transaction rollback ({}) redelivered({}) for {} caught: {}", new Object[]{this.transactionKey, redelivered, ids, e.getMessage()});
        }
    }

    private static String propagationBehaviorToString(int propagationBehavior) {
        String rc;
        switch (propagationBehavior) {
            case 2: {
                rc = "PROPAGATION_MANDATORY";
                break;
            }
            case 6: {
                rc = "PROPAGATION_NESTED";
                break;
            }
            case 5: {
                rc = "PROPAGATION_NEVER";
                break;
            }
            case 4: {
                rc = "PROPAGATION_NOT_SUPPORTED";
                break;
            }
            case 0: {
                rc = "PROPAGATION_REQUIRED";
                break;
            }
            case 3: {
                rc = "PROPAGATION_REQUIRES_NEW";
                break;
            }
            case 1: {
                rc = "PROPAGATION_SUPPORTS";
                break;
            }
            default: {
                rc = "UNKNOWN";
            }
        }
        return rc;
    }
}

