/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.internal;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.zookeeper.KeeperException;
import org.fusesource.fabric.api.FabricException;
import org.fusesource.fabric.api.ZooKeeperClusterService;
import org.fusesource.fabric.internal.FabricConstants;
import org.fusesource.fabric.utils.BundleUtils;
import org.fusesource.fabric.utils.HostUtils;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;
import org.fusesource.fabric.zookeeper.utils.ZookeeperImportUtils;
import org.linkedin.util.clock.Timespan;
import org.linkedin.zookeeper.client.ZKClient;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class ZooKeeperClusterServiceImpl
implements ZooKeeperClusterService {
    private static final String FRAMEWORK_VERSION = "mvn:org.apache.felix/org.apache.felix.framework/" + FabricConstants.FRAMEWORK_VERSION;
    private BundleContext bundleContext;
    private ConfigurationAdmin configurationAdmin;
    private IZKClient zooKeeper;
    private String version = "1.0";
    private boolean ensembleAutoStart = Boolean.parseBoolean(System.getProperty("ensemble.auto.start"));

    public void init() {
        if (this.ensembleAutoStart) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ZooKeeperClusterServiceImpl.this.createLocalServer();
                }
            }).start();
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public void createLocalServer() {
        this.createLocalServer(2181);
    }

    public void createLocalServer(int port) {
        try {
            String karafName = System.getProperty("karaf.name");
            Bundle bundleFabricConfigAdmin = BundleUtils.installOrStopBundle(this.bundleContext, "org.fusesource.fabric.fabric-configadmin", "mvn:org.fusesource.fabric/fabric-configadmin/" + FabricConstants.FABRIC_VERSION);
            Bundle bundleFabricZooKeeper = BundleUtils.installOrStopBundle(this.bundleContext, "org.fusesource.fabric.fabric-zookeeper", "mvn:org.fusesource.fabric/fabric-zookeeper/" + FabricConstants.FABRIC_VERSION);
            Bundle bundleFabricJaas = BundleUtils.installOrStopBundle(this.bundleContext, "org.fusesource.fabric.fabric-jaas  ", "mvn:org.fusesource.fabric/fabric-jaas/" + FabricConstants.FABRIC_VERSION);
            Bundle bundleFabricCommands = BundleUtils.installOrStopBundle(this.bundleContext, "org.fusesource.fabric.fabric-commands  ", "mvn:org.fusesource.fabric/fabric-commands/" + FabricConstants.FABRIC_VERSION);
            Bundle bundleFabricMavenProxy = BundleUtils.installOrStopBundle(this.bundleContext, "org.fusesource.fabric.fabric-commands  ", "mvn:org.fusesource.fabric/fabric-maven-proxy/" + FabricConstants.FABRIC_VERSION);
            String connectionUrl = HostUtils.getLocalHostName() + ":" + Integer.toString(port);
            Configuration config = this.configurationAdmin.createFactoryConfiguration("org.fusesource.fabric.zookeeper.server");
            Properties properties = new Properties();
            properties.put("tickTime", "2000");
            properties.put("initLimit", "10");
            properties.put("syncLimit", "5");
            properties.put("dataDir", "data/zookeeper/0000");
            properties.put("clientPort", Integer.toString(port));
            properties.put("fabric.zookeeper.pid", "org.fusesource.fabric.zookeeper.server-0000");
            config.setBundleLocation(null);
            config.update((Dictionary)properties);
            config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper");
            properties = new Properties();
            properties.put("zookeeper.url", connectionUrl);
            properties.put("fabric.zookeeper.pid", "org.fusesource.fabric.zookeeper");
            config.setBundleLocation(null);
            config.update((Dictionary)properties);
            bundleFabricZooKeeper.start();
            ServiceTracker tracker = new ServiceTracker(this.bundleContext, IZKClient.class.getName(), null);
            tracker.open();
            IZKClient client = (IZKClient)tracker.waitForService(5000L);
            if (client == null) {
                throw new IllegalStateException("Timeout waiting for ZooKeeper client to be registered");
            }
            tracker.close();
            client.waitForConnected();
            String autoImportFrom = System.getProperty("profiles.auto.import.path");
            if (autoImportFrom != null) {
                ZookeeperImportUtils.importFromFileSystem((org.linkedin.zookeeper.client.IZKClient)client, (String)autoImportFrom, (String)"/", null, null, (boolean)false, (boolean)false, (boolean)false);
            }
            String defaultProfile = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{this.version, "default"});
            ZooKeeperClusterServiceImpl.setConfigProperty((org.linkedin.zookeeper.client.IZKClient)client, defaultProfile + "/org.fusesource.fabric.zookeeper.properties", "zookeeper.url", "${zk:" + karafName + "/ip}:" + Integer.toString(port));
            String profileNode = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{this.version, "fabric-ensemble-0000"}) + "/org.fusesource.fabric.zookeeper.server-0000.properties";
            Properties p = new Properties();
            p.put("tickTime", "2000");
            p.put("initLimit", "10");
            p.put("syncLimit", "5");
            p.put("dataDir", "data/zookeeper/0000");
            ZooKeeperUtils.set((org.linkedin.zookeeper.client.IZKClient)client, (String)profileNode, (String)ZooKeeperClusterServiceImpl.toString(p));
            ZooKeeperUtils.set((org.linkedin.zookeeper.client.IZKClient)client, (String)ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{this.version, "fabric-ensemble-0000-1"}), (String)"fabric-ensemble-0000");
            profileNode = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{this.version, "fabric-ensemble-0000-1"}) + "/org.fusesource.fabric.zookeeper.server-0000.properties";
            p = new Properties();
            p.put("clientPort", "2181");
            ZooKeeperUtils.set((org.linkedin.zookeeper.client.IZKClient)client, (String)profileNode, (String)ZooKeeperClusterServiceImpl.toString(p));
            ZooKeeperUtils.set((org.linkedin.zookeeper.client.IZKClient)client, (String)("/fabric/configs/versions/" + this.version + "/general/fabric-ensemble"), (String)"0000");
            ZooKeeperUtils.set((org.linkedin.zookeeper.client.IZKClient)client, (String)("/fabric/configs/versions/" + this.version + "/general/fabric-ensemble/0000"), (String)karafName);
            String fabricProfile = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{this.version, "fabric"});
            ZooKeeperUtils.createDefault((org.linkedin.zookeeper.client.IZKClient)client, (String)fabricProfile, (String)"default");
            p = ZooKeeperClusterServiceImpl.getProperties((org.linkedin.zookeeper.client.IZKClient)client, fabricProfile + "/org.fusesource.fabric.agent.properties", new Properties());
            p.put("feature.fabric-commands", "fabric-commands");
            ZooKeeperUtils.set((org.linkedin.zookeeper.client.IZKClient)client, (String)(fabricProfile + "/org.fusesource.fabric.agent.properties"), (String)ZooKeeperClusterServiceImpl.toString(p));
            ZooKeeperUtils.createDefault((org.linkedin.zookeeper.client.IZKClient)client, (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{karafName}), (String)this.version);
            String assignedProfile = System.getProperty("profile");
            if (assignedProfile != null && !assignedProfile.isEmpty() && !"fabric".equals(assignedProfile)) {
                ZooKeeperUtils.createDefault((org.linkedin.zookeeper.client.IZKClient)client, (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{this.version, karafName}), (String)("fabric fabric-ensemble-0000-1 " + assignedProfile));
            } else {
                ZooKeeperUtils.createDefault((org.linkedin.zookeeper.client.IZKClient)client, (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{this.version, karafName}), (String)"fabric fabric-ensemble-0000-1");
            }
            ZooKeeperUtils.createDefault((org.linkedin.zookeeper.client.IZKClient)client, (String)(defaultProfile + "/org.fusesource.fabric.jaas/encryption.enabled"), (String)"${zk:/fabric/authentication/encryption.enabled}");
            ZooKeeperUtils.createDefault((org.linkedin.zookeeper.client.IZKClient)client, (String)"/fabric/authentication/encryption.enabled", (String)"true");
            ZooKeeperUtils.createDefault((org.linkedin.zookeeper.client.IZKClient)client, (String)"/fabric/authentication/domain", (String)"karaf");
            ZooKeeperUtils.createDefault((org.linkedin.zookeeper.client.IZKClient)client, (String)"/fabric/authentication/users", (String)"admin={CRYPT}21232f297a57a5a743894a0e4a801fc3{CRYPT},admin\nsystem={CRYPT}1d0258c2440a8d19e716292b231e3190{CRYPT},admin");
            if (this.ensembleAutoStart) {
                System.setProperty("ensemble.auto.start", Boolean.FALSE.toString());
                File file = new File(System.getProperty("karaf.base") + "/etc/system.properties");
                org.apache.felix.utils.properties.Properties props = new org.apache.felix.utils.properties.Properties(file);
                props.put("ensemble.auto.start", Boolean.FALSE.toString());
                props.save();
            }
            bundleFabricConfigAdmin.start();
            bundleFabricJaas.start();
            bundleFabricCommands.start();
            if (!System.getProperties().containsKey("agent.auto.start") || Boolean.parseBoolean(System.getProperty("agent.auto.start"))) {
                Bundle bundleFabricAgent = BundleUtils.installOrStopBundle(this.bundleContext, "org.fusesource.fabric.fabric-agent  ", "mvn:org.fusesource.fabric/fabric-agent/" + FabricConstants.FABRIC_VERSION);
                bundleFabricAgent.start();
            }
            bundleFabricMavenProxy.start();
        }
        catch (Exception e) {
            throw new FabricException("Unable to create zookeeper server configuration", e);
        }
    }

    @Override
    public void clean() {
        try {
            Configuration[] configs;
            while ((configs = this.configurationAdmin.listConfigurations("(|(service.factoryPid=org.fusesource.fabric.zookeeper.server)(service.pid=org.fusesource.fabric.zookeeper))")) != null && configs.length > 0) {
                for (Configuration config : configs) {
                    config.delete();
                }
                Thread.sleep(100L);
            }
            File zkDir = new File("data/zookeeper");
            if (zkDir.isDirectory()) {
                File newZkDir = new File("data/zookeeper." + System.currentTimeMillis());
                if (!zkDir.renameTo(newZkDir)) {
                    newZkDir = zkDir;
                }
                ZooKeeperClusterServiceImpl.delete(newZkDir);
            }
        }
        catch (Exception e) {
            throw new FabricException("Unable to delete zookeeper configuration", e);
        }
    }

    private static void delete(File dir) {
        if (dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                ZooKeeperClusterServiceImpl.delete(child);
            }
        }
        if (dir.exists()) {
            dir.delete();
        }
    }

    @Override
    public List<String> getClusterContainers() {
        try {
            Configuration[] configs = this.configurationAdmin.listConfigurations("(service.pid=org.fusesource.fabric.zookeeper)");
            if (configs == null || configs.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<String> list2 = new ArrayList<String>();
            if (this.zooKeeper.exists("/fabric/configs/versions/" + this.version + "/general/fabric-ensemble") != null) {
                String clusterId = this.zooKeeper.getStringData("/fabric/configs/versions/" + this.version + "/general/fabric-ensemble");
                String containers = this.zooKeeper.getStringData("/fabric/configs/versions/" + this.version + "/general/fabric-ensemble/" + clusterId);
                Collections.addAll(list2, containers.split(","));
            }
            return list2;
        }
        catch (Exception e) {
            throw new FabricException("Unable to load zookeeper quorum containers", e);
        }
    }

    @Override
    public String getZooKeeperUrl() {
        try {
            Configuration config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper", null);
            String zooKeeperUrl = (String)config.getProperties().get("zookeeper.url");
            if (zooKeeperUrl == null) {
                throw new IllegalStateException("Unable to find the zookeeper url");
            }
            return zooKeeperUrl;
        }
        catch (Exception e) {
            throw new FabricException("Unable to load zookeeper current url", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCluster(List<String> containers) {
        block20: {
            try {
                String zooKeeperUrl;
                if (containers == null || containers.size() == 2) {
                    throw new IllegalArgumentException("One or at least 3 containers must be used to create a zookeeper ensemble");
                }
                Configuration config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper", null);
                String string = zooKeeperUrl = config != null && config.getProperties() != null ? (String)config.getProperties().get("zookeeper.url") : null;
                if (zooKeeperUrl == null) {
                    if (containers.size() != 1 || !containers.get(0).equals(System.getProperty("karaf.name"))) {
                        throw new FabricException("The first zookeeper cluster must be configured on this container only.");
                    }
                    this.createLocalServer();
                    return;
                }
                String url = ZooKeeperUtils.getSubstitutedPath((org.linkedin.zookeeper.client.IZKClient)this.zooKeeper, (String)("/fabric/configs/versions/" + this.version + "/profiles/default/org.fusesource.fabric.zookeeper.properties#zookeeper.url"));
                if (!url.equals(zooKeeperUrl)) {
                    throw new IllegalStateException("The zookeeper configuration is not properly backed in the zookeeper tree.");
                }
                for (String container : containers) {
                    if (this.zooKeeper.exists(ZkPath.CONTAINER_ALIVE.getPath(new String[]{container})) != null) continue;
                    throw new FabricException("The container " + container + " is not alive");
                }
                HashMap<String, List<Integer>> usedPorts = new HashMap<String, List<Integer>>();
                String oldClusterId = ZooKeeperUtils.get((org.linkedin.zookeeper.client.IZKClient)this.zooKeeper, (String)("/fabric/configs/versions/" + this.version + "/general/fabric-ensemble"));
                if (oldClusterId != null) {
                    Properties p = ZooKeeperClusterServiceImpl.toProperties(this.zooKeeper.getStringData("/fabric/configs/versions/" + this.version + "/profiles/fabric-ensemble-" + oldClusterId + "/org.fusesource.fabric.zookeeper.server-" + oldClusterId + ".properties"));
                    for (Object n : p.keySet()) {
                        String node = (String)n;
                        if (!node.startsWith("server.")) continue;
                        String data = ZooKeeperUtils.getSubstitutedPath((org.linkedin.zookeeper.client.IZKClient)this.zooKeeper, (String)("/fabric/configs/versions/" + this.version + "/profiles/fabric-ensemble-" + oldClusterId + "/org.fusesource.fabric.zookeeper.server-" + oldClusterId + ".properties#" + node));
                        this.addUsedPorts(usedPorts, data);
                    }
                    String datas = ZooKeeperUtils.getSubstitutedPath((org.linkedin.zookeeper.client.IZKClient)this.zooKeeper, (String)("/fabric/configs/versions/" + this.version + "/profiles/default/org.fusesource.fabric.zookeeper.properties#zookeeper.url"));
                    for (String data : datas.split(",")) {
                        this.addUsedPorts(usedPorts, data);
                    }
                }
                String newClusterId = oldClusterId == null ? "0000" : new DecimalFormat("0000").format(Integer.parseInt(oldClusterId) + 1);
                String profileNode = "/fabric/configs/versions/" + this.version + "/profiles/fabric-ensemble-" + newClusterId + "/org.fusesource.fabric.zookeeper.server-" + newClusterId + ".properties";
                Properties profileNodeProperties = new Properties();
                profileNodeProperties.put("tickTime", "2000");
                profileNodeProperties.put("initLimit", "10");
                profileNodeProperties.put("syncLimit", "5");
                profileNodeProperties.put("dataDir", "data/zookeeper/" + newClusterId);
                int index = 1;
                String connectionUrl = "";
                String realConnectionUrl = "";
                String containerList = "";
                for (String container : containers) {
                    String ip = ZooKeeperUtils.getSubstitutedPath((org.linkedin.zookeeper.client.IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER_IP.getPath(new String[]{container}));
                    String profNode = "/fabric/configs/versions/" + this.version + "/profiles/fabric-ensemble-" + newClusterId + "-" + Integer.toString(index);
                    String pidNode = profNode + "/org.fusesource.fabric.zookeeper.server-" + newClusterId + ".properties";
                    Properties pidNodeProperties = new Properties();
                    ZooKeeperUtils.add((org.linkedin.zookeeper.client.IZKClient)this.zooKeeper, (String)profNode, (String)("fabric-ensemble-" + newClusterId));
                    String port1 = Integer.toString(this.findPort(usedPorts, ip, 2181));
                    if (containers.size() > 1) {
                        String port2 = Integer.toString(this.findPort(usedPorts, ip, 2888));
                        String port3 = Integer.toString(this.findPort(usedPorts, ip, 3888));
                        profileNodeProperties.put("server." + Integer.toString(index), "${zk:" + container + "/ip}:" + port2 + ":" + port3);
                        pidNodeProperties.put("server.id", Integer.toString(index));
                    }
                    pidNodeProperties.put("clientPort", port1);
                    ZooKeeperUtils.set((org.linkedin.zookeeper.client.IZKClient)this.zooKeeper, (String)pidNode, (String)ZooKeeperClusterServiceImpl.toString(pidNodeProperties));
                    ZooKeeperUtils.add((org.linkedin.zookeeper.client.IZKClient)this.zooKeeper, (String)("/fabric/configs/versions/" + this.version + "/containers/" + container), (String)("fabric-ensemble-" + newClusterId + "-" + Integer.toString(index)));
                    if (connectionUrl.length() > 0) {
                        connectionUrl = connectionUrl + ",";
                        realConnectionUrl = realConnectionUrl + ",";
                    }
                    connectionUrl = connectionUrl + "${zk:" + container + "/ip}:" + port1;
                    realConnectionUrl = realConnectionUrl + ip + ":" + port1;
                    if (containerList.length() > 0) {
                        containerList = containerList + ",";
                    }
                    containerList = containerList + container;
                    ++index;
                }
                ZooKeeperUtils.set((org.linkedin.zookeeper.client.IZKClient)this.zooKeeper, (String)profileNode, (String)ZooKeeperClusterServiceImpl.toString(profileNodeProperties));
                if (oldClusterId != null) {
                    ZKClient dst = new ZKClient(realConnectionUrl, Timespan.ONE_MINUTE, null);
                    try {
                        dst.start();
                        dst.waitForStart(new Timespan(30L, Timespan.TimeUnit.SECOND));
                        ZooKeeperUtils.copy((org.linkedin.zookeeper.client.IZKClient)this.zooKeeper, (org.linkedin.zookeeper.client.IZKClient)dst, (String)"/fabric/registry");
                        ZooKeeperUtils.copy((org.linkedin.zookeeper.client.IZKClient)this.zooKeeper, (org.linkedin.zookeeper.client.IZKClient)dst, (String)"/fabric/authentication");
                        ZooKeeperUtils.copy((org.linkedin.zookeeper.client.IZKClient)this.zooKeeper, (org.linkedin.zookeeper.client.IZKClient)dst, (String)"/fabric/configs");
                        for (String container : containers) {
                            String alivePath = "/fabric/registry/containers/alive/" + container;
                            if (dst.exists(alivePath) == null) continue;
                            dst.deleteWithChildren(alivePath);
                        }
                        ZooKeeperUtils.set((org.linkedin.zookeeper.client.IZKClient)dst, (String)("/fabric/configs/versions/" + this.version + "/general/fabric-ensemble"), (String)newClusterId);
                        ZooKeeperUtils.set((org.linkedin.zookeeper.client.IZKClient)dst, (String)("/fabric/configs/versions/" + this.version + "/general/fabric-ensemble/" + newClusterId), (String)containerList);
                        for (String container : dst.getChildren("/fabric/configs/versions/" + this.version + "/containers")) {
                            ZooKeeperUtils.remove((org.linkedin.zookeeper.client.IZKClient)dst, (String)("/fabric/configs/versions/" + this.version + "/containers/" + container), (String)("fabric-ensemble-" + oldClusterId + "-.*"));
                        }
                        ZooKeeperClusterServiceImpl.setConfigProperty((org.linkedin.zookeeper.client.IZKClient)dst, "/fabric/configs/versions/" + this.version + "/profiles/default/org.fusesource.fabric.zookeeper.properties", "zookeeper.url", connectionUrl);
                        ZooKeeperClusterServiceImpl.setConfigProperty((org.linkedin.zookeeper.client.IZKClient)this.zooKeeper, "/fabric/configs/versions/" + this.version + "/profiles/default/org.fusesource.fabric.zookeeper.properties", "zookeeper.url", connectionUrl);
                        break block20;
                    }
                    finally {
                        dst.destroy();
                    }
                }
                ZooKeeperClusterServiceImpl.setConfigProperty((org.linkedin.zookeeper.client.IZKClient)this.zooKeeper, "/fabric/configs/versions/" + this.version + "/profiles/default/org.fusesource.fabric.zookeeper.properties", "zookeeper.url", connectionUrl);
            }
            catch (Exception e) {
                throw new FabricException("Unable to create zookeeper quorum: " + e.getMessage(), e);
            }
        }
    }

    public static String toString(Properties source) throws IOException {
        StringWriter writer = new StringWriter();
        source.store(writer, null);
        return writer.toString();
    }

    public static Properties toProperties(String source) throws IOException {
        Properties rc = new Properties();
        rc.load(new StringReader(source));
        return rc;
    }

    public static Properties getProperties(org.linkedin.zookeeper.client.IZKClient client, String file, Properties defaultValue) throws InterruptedException, KeeperException, IOException {
        try {
            String v = ZooKeeperUtils.get((org.linkedin.zookeeper.client.IZKClient)client, (String)file);
            if (v != null) {
                return ZooKeeperClusterServiceImpl.toProperties(v);
            }
            return defaultValue;
        }
        catch (KeeperException.NoNodeException e) {
            return defaultValue;
        }
    }

    public static void setConfigProperty(org.linkedin.zookeeper.client.IZKClient client, String file, String prop, String value) throws InterruptedException, KeeperException, IOException {
        Properties p = ZooKeeperClusterServiceImpl.getProperties(client, file, new Properties());
        p.setProperty(prop, value);
        ZooKeeperUtils.set((org.linkedin.zookeeper.client.IZKClient)client, (String)file, (String)ZooKeeperClusterServiceImpl.toString(p));
    }

    private int findPort(Map<String, List<Integer>> usedPorts, String ip, int port) {
        List<Integer> ports = usedPorts.get(ip);
        if (ports == null) {
            ports = new ArrayList<Integer>();
            usedPorts.put(ip, ports);
        }
        while (true) {
            if (!ports.contains(port)) {
                ports.add(port);
                return port;
            }
            ++port;
        }
    }

    private void addUsedPorts(Map<String, List<Integer>> usedPorts, String data) {
        String[] parts = data.split(":");
        List<Integer> ports = usedPorts.get(parts[0]);
        if (ports == null) {
            ports = new ArrayList<Integer>();
            usedPorts.put(parts[0], ports);
        }
        for (int i = 1; i < parts.length; ++i) {
            ports.add(Integer.parseInt(parts[i]));
        }
    }

    @Override
    public void addToCluster(List<String> containers) {
        try {
            List<String> current = this.getClusterContainers();
            current.addAll(containers);
            this.createCluster(current);
        }
        catch (Exception e) {
            throw new FabricException("Unable to add containers to fabric ensemble: " + e.getMessage(), e);
        }
    }

    @Override
    public void removeFromCluster(List<String> containers) {
        try {
            List<String> current = this.getClusterContainers();
            current.removeAll(containers);
            this.createCluster(current);
        }
        catch (Exception e) {
            throw new FabricException("Unable to remove containers to fabric ensemble: " + e.getMessage(), e);
        }
    }
}

