/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.log.elasticsearch;

import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.fusesource.insight.log.elasticsearch.ElasticSender;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class InsightEventHandler
implements EventHandler {
    private String name;
    private String index;
    private String type;
    private ElasticSender sender;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ElasticSender getSender() {
        return this.sender;
    }

    public void setSender(ElasticSender sender) {
        this.sender = sender;
    }

    public void init() {
        CreateIndexRequest request = new CreateIndexRequest(this.index);
        this.sender.createIndexIfNeeded(request);
    }

    public void handleEvent(Event event) {
        try {
            StringBuilder writer = new StringBuilder();
            writer.append("{ host : ");
            ElasticSender.quote(this.name, writer);
            writer.append(", topic: ");
            ElasticSender.quote(event.getTopic(), writer);
            writer.append(", properties: { ");
            boolean first = true;
            for (String name : event.getPropertyNames()) {
                if (first) {
                    first = false;
                } else {
                    writer.append(", ");
                }
                ElasticSender.quote(name, writer);
                writer.append(": ");
                ElasticSender.quote(event.getProperty(name).toString(), writer);
            }
            writer.append(" } }");
            IndexRequest request = new IndexRequest().index(this.index).type(this.type).source(writer.toString()).create(true);
            this.sender.put(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

