/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.AttributeSource;

public final class EdgeNGramTokenizer
extends Tokenizer {
    public static final Side DEFAULT_SIDE = Side.FRONT;
    public static final int DEFAULT_MAX_GRAM_SIZE = 1;
    public static final int DEFAULT_MIN_GRAM_SIZE = 1;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private int minGram;
    private int maxGram;
    private int gramSize;
    private Side side;
    private boolean started = false;
    private int inLen;
    private String inStr;

    public EdgeNGramTokenizer(Reader input, Side side, int minGram, int maxGram) {
        super(input);
        this.init(side, minGram, maxGram);
    }

    public EdgeNGramTokenizer(AttributeSource source, Reader input, Side side, int minGram, int maxGram) {
        super(source, input);
        this.init(side, minGram, maxGram);
    }

    public EdgeNGramTokenizer(AttributeSource.AttributeFactory factory, Reader input, Side side, int minGram, int maxGram) {
        super(factory, input);
        this.init(side, minGram, maxGram);
    }

    public EdgeNGramTokenizer(Reader input, String sideLabel, int minGram, int maxGram) {
        this(input, Side.getSide(sideLabel), minGram, maxGram);
    }

    public EdgeNGramTokenizer(AttributeSource source, Reader input, String sideLabel, int minGram, int maxGram) {
        this(source, input, Side.getSide(sideLabel), minGram, maxGram);
    }

    public EdgeNGramTokenizer(AttributeSource.AttributeFactory factory, Reader input, String sideLabel, int minGram, int maxGram) {
        this(factory, input, Side.getSide(sideLabel), minGram, maxGram);
    }

    private void init(Side side, int minGram, int maxGram) {
        if (side == null) {
            throw new IllegalArgumentException("sideLabel must be either front or back");
        }
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
        this.side = side;
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        if (!this.started) {
            this.started = true;
            char[] chars = new char[1024];
            int charsRead = this.input.read(chars);
            this.inStr = new String(chars, 0, charsRead).trim();
            this.inLen = this.inStr.length();
            this.gramSize = this.minGram;
        }
        if (this.gramSize > this.inLen) {
            return false;
        }
        if (this.gramSize > this.maxGram) {
            return false;
        }
        int start = this.side == Side.FRONT ? 0 : this.inLen - this.gramSize;
        int end = start + this.gramSize;
        this.termAtt.setEmpty().append(this.inStr, start, end);
        this.offsetAtt.setOffset(this.correctOffset(start), this.correctOffset(end));
        ++this.gramSize;
        return true;
    }

    public final void end() {
        int finalOffset = this.inLen;
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    public void reset(Reader input) throws IOException {
        super.reset(input);
        this.reset();
    }

    public void reset() throws IOException {
        super.reset();
        this.started = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Side {
        FRONT{

            public String getLabel() {
                return "front";
            }
        }
        ,
        BACK{

            public String getLabel() {
                return "back";
            }
        };


        public abstract String getLabel();

        public static Side getSide(String sideName) {
            if (FRONT.getLabel().equals(sideName)) {
                return FRONT;
            }
            if (BACK.getLabel().equals(sideName)) {
                return BACK;
            }
            return null;
        }
    }
}

