/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.HandlesStreamOutput;
import org.elasticsearch.common.io.stream.LZFStreamOutput;
import org.elasticsearch.common.thread.ThreadLocals;

public class CachedStreamOutput {
    private static final ThreadLocal<ThreadLocals.CleanableValue<Entry>> cache = new ThreadLocal<ThreadLocals.CleanableValue<Entry>>(){

        @Override
        protected ThreadLocals.CleanableValue<Entry> initialValue() {
            BytesStreamOutput bytes = new BytesStreamOutput();
            HandlesStreamOutput handles = new HandlesStreamOutput(bytes);
            LZFStreamOutput lzf = new LZFStreamOutput(bytes, true);
            return new ThreadLocals.CleanableValue<Entry>(new Entry(bytes, handles, lzf));
        }
    };

    public static BytesStreamOutput cachedBytes() {
        BytesStreamOutput os = CachedStreamOutput.cache.get().get().bytes;
        os.reset();
        return os;
    }

    public static LZFStreamOutput cachedLZFBytes() throws IOException {
        LZFStreamOutput lzf = CachedStreamOutput.cache.get().get().lzf;
        lzf.reset();
        return lzf;
    }

    public static HandlesStreamOutput cachedHandlesLzfBytes() throws IOException {
        Entry entry = cache.get().get();
        HandlesStreamOutput os = entry.handles;
        os.reset(entry.lzf);
        return os;
    }

    public static HandlesStreamOutput cachedHandlesBytes() throws IOException {
        Entry entry = cache.get().get();
        HandlesStreamOutput os = entry.handles;
        os.reset(entry.bytes);
        return os;
    }

    static class Entry {
        final BytesStreamOutput bytes;
        final HandlesStreamOutput handles;
        final LZFStreamOutput lzf;

        Entry(BytesStreamOutput bytes, HandlesStreamOutput handles, LZFStreamOutput lzf) {
            this.bytes = bytes;
            this.handles = handles;
            this.lzf = lzf;
        }
    }
}

