/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilterClause;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.OpenBitSetDISI;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.OpenBitDocSet;

public class XBooleanFilter
extends Filter {
    ArrayList<Filter> shouldFilters = null;
    ArrayList<Filter> notFilters = null;
    ArrayList<Filter> mustFilters = null;

    private DocIdSetIterator getDISI(ArrayList<Filter> filters, int index, IndexReader reader) throws IOException {
        return filters.get(index).getDocIdSet(reader).iterator();
    }

    public List<Filter> getShouldFilters() {
        return this.shouldFilters;
    }

    public List<Filter> getMustFilters() {
        return this.mustFilters;
    }

    public List<Filter> getNotFilters() {
        return this.notFilters;
    }

    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        DocIdSet dis;
        int i;
        OpenBitSetDISI res = null;
        if (this.shouldFilters != null) {
            for (i = 0; i < this.shouldFilters.size(); ++i) {
                if (res == null) {
                    res = new OpenBitSetDISI(this.getDISI(this.shouldFilters, i, reader), reader.maxDoc());
                    continue;
                }
                dis = this.shouldFilters.get(i).getDocIdSet(reader);
                if (dis instanceof OpenBitSet) {
                    res.or((OpenBitSet)dis);
                    continue;
                }
                if (dis instanceof OpenBitDocSet) {
                    res.or(((OpenBitDocSet)dis).set());
                    continue;
                }
                res.inPlaceOr(this.getDISI(this.shouldFilters, i, reader));
            }
        }
        if (this.notFilters != null) {
            for (i = 0; i < this.notFilters.size(); ++i) {
                if (res == null) {
                    res = new OpenBitSetDISI(this.getDISI(this.notFilters, i, reader), reader.maxDoc());
                    res.flip(0L, reader.maxDoc());
                    continue;
                }
                dis = this.notFilters.get(i).getDocIdSet(reader);
                if (dis instanceof OpenBitSet) {
                    res.andNot((OpenBitSet)dis);
                    continue;
                }
                if (dis instanceof OpenBitDocSet) {
                    res.andNot(((OpenBitDocSet)dis).set());
                    continue;
                }
                res.inPlaceNot(this.getDISI(this.notFilters, i, reader));
            }
        }
        if (this.mustFilters != null) {
            for (i = 0; i < this.mustFilters.size(); ++i) {
                if (res == null) {
                    res = new OpenBitSetDISI(this.getDISI(this.mustFilters, i, reader), reader.maxDoc());
                    continue;
                }
                dis = this.mustFilters.get(i).getDocIdSet(reader);
                if (dis instanceof OpenBitSet) {
                    res.and((OpenBitSet)dis);
                    continue;
                }
                if (dis instanceof OpenBitDocSet) {
                    res.and(((OpenBitDocSet)dis).set());
                    continue;
                }
                res.inPlaceAnd(this.getDISI(this.mustFilters, i, reader));
            }
        }
        if (res != null) {
            return new OpenBitDocSet(res);
        }
        return DocSet.EMPTY_DOC_SET;
    }

    protected final DocIdSet finalResult(OpenBitSetDISI result, int maxDocs) {
        return result;
    }

    public void add(FilterClause filterClause) {
        if (filterClause.getOccur().equals((Object)BooleanClause.Occur.MUST)) {
            if (this.mustFilters == null) {
                this.mustFilters = new ArrayList();
            }
            this.mustFilters.add(filterClause.getFilter());
        }
        if (filterClause.getOccur().equals((Object)BooleanClause.Occur.SHOULD)) {
            if (this.shouldFilters == null) {
                this.shouldFilters = new ArrayList();
            }
            this.shouldFilters.add(filterClause.getFilter());
        }
        if (filterClause.getOccur().equals((Object)BooleanClause.Occur.MUST_NOT)) {
            if (this.notFilters == null) {
                this.notFilters = new ArrayList();
            }
            this.notFilters.add(filterClause.getFilter());
        }
    }

    private boolean equalFilters(ArrayList<Filter> filters1, ArrayList<Filter> filters2) {
        return filters1 == filters2 || filters1 != null && filters1.equals(filters2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        XBooleanFilter other = (XBooleanFilter)obj;
        return this.equalFilters(this.notFilters, other.notFilters) && this.equalFilters(this.mustFilters, other.mustFilters) && this.equalFilters(this.shouldFilters, other.shouldFilters);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.mustFilters ? 0 : this.mustFilters.hashCode());
        hash = 31 * hash + (null == this.notFilters ? 0 : this.notFilters.hashCode());
        hash = 31 * hash + (null == this.shouldFilters ? 0 : this.shouldFilters.hashCode());
        return hash;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("BooleanFilter(");
        this.appendFilters(this.shouldFilters, "", buffer);
        this.appendFilters(this.mustFilters, "+", buffer);
        this.appendFilters(this.notFilters, "-", buffer);
        buffer.append(")");
        return buffer.toString();
    }

    private void appendFilters(ArrayList<Filter> filters, String occurString, StringBuilder buffer) {
        if (filters != null) {
            for (int i = 0; i < filters.size(); ++i) {
                buffer.append(' ');
                buffer.append(occurString);
                buffer.append(filters.get(i).toString());
            }
        }
    }
}

