/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentParser;

public class XContentHelper {
    public static void mergeDefaults(Map<String, Object> content, Map<String, Object> defaults) {
        for (Map.Entry<String, Object> defaultEntry : defaults.entrySet()) {
            if (!content.containsKey(defaultEntry.getKey())) {
                content.put(defaultEntry.getKey(), defaultEntry.getValue());
                continue;
            }
            if (content.get(defaultEntry.getKey()) instanceof Map && defaultEntry.getValue() instanceof Map) {
                XContentHelper.mergeDefaults((Map)content.get(defaultEntry.getKey()), (Map)defaultEntry.getValue());
                continue;
            }
            if (!(content.get(defaultEntry.getKey()) instanceof List) || !(defaultEntry.getValue() instanceof List)) continue;
            ArrayList mergedList = new ArrayList();
            mergedList.addAll((Collection)defaultEntry.getValue());
            mergedList.addAll((Collection)content.get(defaultEntry.getKey()));
            content.put(defaultEntry.getKey(), mergedList);
        }
    }

    public static void copyCurrentStructure(XContentGenerator generator, XContentParser parser) throws IOException {
        XContentParser.Token t = parser.currentToken();
        if (t == XContentParser.Token.FIELD_NAME) {
            generator.writeFieldName(parser.currentName());
            t = parser.nextToken();
        }
        switch (t) {
            case START_ARRAY: {
                generator.writeStartArray();
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    XContentHelper.copyCurrentStructure(generator, parser);
                }
                generator.writeEndArray();
                break;
            }
            case START_OBJECT: {
                generator.writeStartObject();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    XContentHelper.copyCurrentStructure(generator, parser);
                }
                generator.writeEndObject();
                break;
            }
            default: {
                XContentHelper.copyCurrentEvent(generator, parser);
            }
        }
    }

    public static void copyCurrentEvent(XContentGenerator generator, XContentParser parser) throws IOException {
        switch (parser.currentToken()) {
            case START_OBJECT: {
                generator.writeStartObject();
                break;
            }
            case END_OBJECT: {
                generator.writeEndObject();
                break;
            }
            case START_ARRAY: {
                generator.writeStartArray();
                break;
            }
            case END_ARRAY: {
                generator.writeEndArray();
                break;
            }
            case FIELD_NAME: {
                generator.writeFieldName(parser.currentName());
                break;
            }
            case VALUE_STRING: {
                if (parser.hasTextCharacters()) {
                    generator.writeString(parser.textCharacters(), parser.textOffset(), parser.textLength());
                    break;
                }
                generator.writeString(parser.text());
                break;
            }
            case VALUE_NUMBER: {
                switch (parser.numberType()) {
                    case INT: {
                        generator.writeNumber(parser.intValue());
                        break;
                    }
                    case LONG: {
                        generator.writeNumber(parser.longValue());
                        break;
                    }
                    case FLOAT: {
                        generator.writeNumber(parser.floatValue());
                        break;
                    }
                    case DOUBLE: {
                        generator.writeNumber(parser.doubleValue());
                    }
                }
                break;
            }
            case VALUE_BOOLEAN: {
                generator.writeBoolean(parser.booleanValue());
                break;
            }
            case VALUE_NULL: {
                generator.writeNull();
            }
        }
    }
}

