/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CharFilterFactoryFactory;
import org.elasticsearch.index.analysis.CustomAnalyzer;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactoryFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.index.analysis.TokenizerFactoryFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class CustomAnalyzerProvider
extends AbstractIndexAnalyzerProvider<CustomAnalyzer> {
    private final TokenizerFactory tokenizerFactory;
    private final CharFilterFactory[] charFilterFactories;
    private final TokenFilterFactory[] tokenFilterFactories;
    private final CustomAnalyzer customAnalyzer;

    @Inject
    public CustomAnalyzerProvider(Index index, Map<String, TokenizerFactoryFactory> tokenizerFactories, Map<String, CharFilterFactoryFactory> charFilterFactories, Map<String, TokenFilterFactoryFactory> tokenFilterFactories, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        String[] tokenFilterNames;
        String[] charFilterNames;
        String tokenizerName = settings.get("tokenizer");
        if (tokenizerName == null) {
            throw new IllegalArgumentException("Custom Analyzer [" + name + "] must be configured with a tokenizer");
        }
        TokenizerFactoryFactory tokenizerFactoryFactory = tokenizerFactories.get(tokenizerName);
        if (tokenizerFactoryFactory == null) {
            throw new IllegalArgumentException("Custom Analyzer [" + name + "] failed to find tokenizer under name [" + tokenizerName + "]");
        }
        Settings tokenizerSettings = indexSettings.getGroups("index.analysis.tokenizer").get(tokenizerName);
        if (tokenizerSettings == null) {
            tokenizerSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
        }
        this.tokenizerFactory = tokenizerFactoryFactory.create(tokenizerName, tokenizerSettings);
        ArrayList<CharFilterFactory> charFilters = Lists.newArrayList();
        for (String charFilterName : charFilterNames = settings.getAsArray("char_filter")) {
            CharFilterFactoryFactory charFilterFactoryFactory = charFilterFactories.get(charFilterName);
            if (charFilterFactoryFactory == null) {
                throw new IllegalArgumentException("Custom Analyzer [" + name + "] failed to find char filter under name [" + charFilterName + "]");
            }
            Settings charFilterSettings = indexSettings.getGroups("index.analysis.char_filter").get(charFilterName);
            if (charFilterSettings == null) {
                charFilterSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
            }
            charFilters.add(charFilterFactoryFactory.create(charFilterName, charFilterSettings));
        }
        this.charFilterFactories = charFilters.toArray(new CharFilterFactory[charFilters.size()]);
        ArrayList<TokenFilterFactory> tokenFilters = Lists.newArrayList();
        for (String tokenFilterName : tokenFilterNames = settings.getAsArray("filter")) {
            TokenFilterFactoryFactory tokenFilterFactoryFactory = tokenFilterFactories.get(tokenFilterName);
            if (tokenFilterFactoryFactory == null) {
                throw new IllegalArgumentException("Custom Analyzer [" + name + "] failed to find token filter under name [" + tokenFilterName + "]");
            }
            Settings tokenFilterSettings = indexSettings.getGroups("index.analysis.filter").get(tokenFilterName);
            if (tokenFilterSettings == null) {
                tokenFilterSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
            }
            tokenFilters.add(tokenFilterFactoryFactory.create(tokenFilterName, tokenFilterSettings));
        }
        this.tokenFilterFactories = tokenFilters.toArray(new TokenFilterFactory[tokenFilters.size()]);
        this.customAnalyzer = new CustomAnalyzer(this.tokenizerFactory, this.charFilterFactories, this.tokenFilterFactories);
    }

    @Override
    public CustomAnalyzer get() {
        return this.customAnalyzer;
    }
}

