/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.xcontent.AbstractFieldMapper;
import org.elasticsearch.index.mapper.xcontent.ContentPath;
import org.elasticsearch.index.mapper.xcontent.IncludeInAllMapper;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;
import org.elasticsearch.index.mapper.xcontent.XContentMapperBuilders;
import org.elasticsearch.index.mapper.xcontent.XContentTypeParsers;

public class MultiFieldMapper
implements XContentMapper,
IncludeInAllMapper {
    public static final String CONTENT_TYPE = "multi_field";
    private final String name;
    private final ContentPath.Type pathType;
    private final Object mutex = new Object();
    private volatile ImmutableMap<String, XContentMapper> mappers = ImmutableMap.of();
    private volatile XContentMapper defaultMapper;

    public MultiFieldMapper(String name, ContentPath.Type pathType, XContentMapper defaultMapper) {
        this(name, pathType, new HashMap<String, XContentMapper>(), defaultMapper);
    }

    public MultiFieldMapper(String name, ContentPath.Type pathType, Map<String, XContentMapper> mappers, XContentMapper defaultMapper) {
        this.name = name;
        this.pathType = pathType;
        this.mappers = ImmutableMap.copyOf(mappers);
        this.defaultMapper = defaultMapper;
        for (XContentMapper mapper : mappers.values()) {
            if (!(mapper instanceof IncludeInAllMapper)) continue;
            ((IncludeInAllMapper)mapper).includeInAll(false);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void includeInAll(Boolean includeInAll) {
        if (includeInAll != null && this.defaultMapper != null && this.defaultMapper instanceof IncludeInAllMapper) {
            ((IncludeInAllMapper)this.defaultMapper).includeInAll(includeInAll);
        }
    }

    public ContentPath.Type pathType() {
        return this.pathType;
    }

    public XContentMapper defaultMapper() {
        return this.defaultMapper;
    }

    public ImmutableMap<String, XContentMapper> mappers() {
        return this.mappers;
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        ContentPath.Type origPathType = context.path().pathType();
        context.path().pathType(this.pathType);
        if (this.defaultMapper != null) {
            this.defaultMapper.parse(context);
        }
        context.path().add(this.name);
        for (XContentMapper mapper : this.mappers.values()) {
            mapper.parse(context);
        }
        context.path().remove();
        context.path().pathType(origPathType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(XContentMapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        if (!(mergeWith instanceof MultiFieldMapper) && !(mergeWith instanceof AbstractFieldMapper)) {
            mergeContext.addConflict("Can't merge a non multi_field / non simple mapping [" + mergeWith.name() + "] with a multi_field mapping [" + this.name() + "]");
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (mergeWith instanceof AbstractFieldMapper) {
                if (this.defaultMapper == null && !mergeContext.mergeFlags().simulate()) {
                    this.defaultMapper = mergeWith;
                    mergeContext.docMapper().addFieldMapper((FieldMapper)((Object)this.defaultMapper));
                }
            } else {
                MultiFieldMapper mergeWithMultiField = (MultiFieldMapper)mergeWith;
                if (this.defaultMapper == null) {
                    if (mergeWithMultiField.defaultMapper != null && !mergeContext.mergeFlags().simulate()) {
                        this.defaultMapper = mergeWithMultiField.defaultMapper;
                        mergeContext.docMapper().addFieldMapper((FieldMapper)((Object)this.defaultMapper));
                    }
                } else if (mergeWithMultiField.defaultMapper != null) {
                    this.defaultMapper.merge(mergeWithMultiField.defaultMapper, mergeContext);
                }
                for (XContentMapper mergeWithMapper : mergeWithMultiField.mappers.values()) {
                    XContentMapper mergeIntoMapper = this.mappers.get(mergeWithMapper.name());
                    if (mergeIntoMapper == null) {
                        if (mergeContext.mergeFlags().simulate()) continue;
                        if (mergeWithMapper instanceof IncludeInAllMapper) {
                            ((IncludeInAllMapper)mergeWithMapper).includeInAll(false);
                        }
                        this.mappers = MapBuilder.newMapBuilder(this.mappers).put(mergeWithMapper.name(), mergeWithMapper).immutableMap();
                        if (!(mergeWithMapper instanceof AbstractFieldMapper)) continue;
                        mergeContext.docMapper().addFieldMapper((FieldMapper)((Object)mergeWithMapper));
                        continue;
                    }
                    mergeIntoMapper.merge(mergeWithMapper, mergeContext);
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.defaultMapper != null) {
            this.defaultMapper.close();
        }
        for (XContentMapper mapper : this.mappers.values()) {
            mapper.close();
        }
    }

    @Override
    public void traverse(FieldMapperListener fieldMapperListener) {
        if (this.defaultMapper != null) {
            this.defaultMapper.traverse(fieldMapperListener);
        }
        for (XContentMapper mapper : this.mappers.values()) {
            mapper.traverse(fieldMapperListener);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field("type", CONTENT_TYPE);
        if (this.pathType != Defaults.PATH_TYPE) {
            builder.field("path", this.pathType.name().toLowerCase());
        }
        builder.startObject("fields");
        if (this.defaultMapper != null) {
            this.defaultMapper.toXContent(builder, params);
        }
        for (XContentMapper mapper : this.mappers.values()) {
            mapper.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static class TypeParser
    implements XContentMapper.TypeParser {
        @Override
        public XContentMapper.Builder parse(String name, Map<String, Object> node, XContentMapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = XContentMapperBuilders.multiField(name);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("path")) {
                    builder.pathType(XContentTypeParsers.parsePathType(name, fieldNode.toString()));
                    continue;
                }
                if (!fieldName.equals("fields")) continue;
                Map fieldsNode = (Map)fieldNode;
                for (Map.Entry entry1 : fieldsNode.entrySet()) {
                    String propName = (String)entry1.getKey();
                    Map propNode = (Map)entry1.getValue();
                    Object typeNode = propNode.get("type");
                    if (typeNode == null) {
                        throw new MapperParsingException("No type specified for property [" + propName + "]");
                    }
                    String type = typeNode.toString();
                    XContentMapper.TypeParser typeParser = parserContext.typeParser(type);
                    if (typeParser == null) {
                        throw new MapperParsingException("No handler for type [" + type + "] declared on field [" + fieldName + "]");
                    }
                    builder.add(typeParser.parse(propName, propNode, parserContext));
                }
            }
            return builder;
        }
    }

    public static class Builder
    extends XContentMapper.Builder<Builder, MultiFieldMapper> {
        private ContentPath.Type pathType = Defaults.PATH_TYPE;
        private final List<XContentMapper.Builder> mappersBuilders = Lists.newArrayList();
        private XContentMapper.Builder defaultMapperBuilder;

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public Builder pathType(ContentPath.Type pathType) {
            this.pathType = pathType;
            return this;
        }

        public Builder add(XContentMapper.Builder builder) {
            if (builder.name.equals(this.name)) {
                this.defaultMapperBuilder = builder;
            } else {
                this.mappersBuilders.add(builder);
            }
            return this;
        }

        @Override
        public MultiFieldMapper build(XContentMapper.BuilderContext context) {
            ContentPath.Type origPathType = context.path().pathType();
            context.path().pathType(this.pathType);
            XContentMapper defaultMapper = null;
            if (this.defaultMapperBuilder != null) {
                defaultMapper = (XContentMapper)this.defaultMapperBuilder.build(context);
            }
            context.path().add(this.name);
            HashMap<String, XContentMapper> mappers = new HashMap<String, XContentMapper>();
            for (XContentMapper.Builder builder : this.mappersBuilders) {
                Object mapper = builder.build(context);
                mappers.put(mapper.name(), (XContentMapper)mapper);
            }
            context.path().remove();
            context.path().pathType(origPathType);
            return new MultiFieldMapper(this.name, this.pathType, mappers, defaultMapper);
        }
    }

    public static class Defaults {
        public static final ContentPath.Type PATH_TYPE = ContentPath.Type.FULL;
    }
}

