/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentQueryParser;
import org.elasticsearch.index.settings.IndexSettings;

public class DisMaxQueryParser
extends AbstractIndexComponent
implements XContentQueryParser {
    public static final String NAME = "dis_max";

    @Inject
    public DisMaxQueryParser(Index index, @IndexSettings Settings settings) {
        super(index, settings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        float tieBreaker = 0.0f;
        ArrayList<Query> queries = Lists.newArrayList();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"queries".equals(currentFieldName)) continue;
                queries.add(parseContext.parseInnerQuery());
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (!"queries".equals(currentFieldName)) continue;
                while (token != XContentParser.Token.END_ARRAY) {
                    queries.add(parseContext.parseInnerQuery());
                    token = parser.nextToken();
                }
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if (!"tie_breaker".equals(currentFieldName) && !"tieBreaker".equals(currentFieldName)) continue;
            tieBreaker = parser.floatValue();
        }
        DisjunctionMaxQuery query = new DisjunctionMaxQuery(queries, tieBreaker);
        query.setBoost(boost);
        return query;
    }
}

