/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.queryParser.MapperQueryParser;
import org.apache.lucene.queryParser.MultiFieldMapperQueryParser;
import org.apache.lucene.queryParser.MultiFieldQueryParserSettings;
import org.apache.lucene.queryParser.QueryParserSettings;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.engine.IndexEngine;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.xcontent.XContentFilterParser;
import org.elasticsearch.index.query.xcontent.XContentIndexQueryParser;
import org.elasticsearch.index.query.xcontent.XContentQueryParser;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.script.ScriptService;

public class QueryParseContext {
    private final Index index;
    XContentIndexQueryParser indexQueryParser;
    private final Map<String, Filter> namedFilters = Maps.newHashMap();
    private final MapperQueryParser queryParser = new MapperQueryParser(this);
    private final MultiFieldMapperQueryParser multiFieldQueryParser = new MultiFieldMapperQueryParser(this);
    private XContentParser parser;

    public QueryParseContext(Index index, XContentIndexQueryParser indexQueryParser) {
        this.index = index;
        this.indexQueryParser = indexQueryParser;
    }

    public void reset(XContentParser jp) {
        this.parser = jp;
        this.namedFilters.clear();
    }

    public XContentParser parser() {
        return this.parser;
    }

    public ScriptService scriptService() {
        return this.indexQueryParser.scriptService;
    }

    public MapperService mapperService() {
        return this.indexQueryParser.mapperService;
    }

    public IndexEngine indexEngine() {
        return this.indexQueryParser.indexEngine;
    }

    @Nullable
    public SimilarityService similarityService() {
        return this.indexQueryParser.similarityService;
    }

    public Similarity searchSimilarity() {
        return this.indexQueryParser.similarityService != null ? this.indexQueryParser.similarityService.defaultSearchSimilarity() : null;
    }

    public IndexCache indexCache() {
        return this.indexQueryParser.indexCache;
    }

    public MapperQueryParser singleQueryParser(QueryParserSettings settings) {
        this.queryParser.reset(settings);
        return this.queryParser;
    }

    public MultiFieldMapperQueryParser multiQueryParser(MultiFieldQueryParserSettings settings) {
        this.multiFieldQueryParser.reset(settings);
        return this.multiFieldQueryParser;
    }

    public Filter cacheFilter(Filter filter) {
        return this.indexQueryParser.indexCache.filter().cache(filter);
    }

    public void addNamedFilter(String name, Filter filter) {
        this.namedFilters.put(name, filter);
    }

    public ImmutableMap<String, Filter> copyNamedFilters() {
        if (this.namedFilters.isEmpty()) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf(this.namedFilters);
    }

    public Query parseInnerQuery() throws IOException, QueryParsingException {
        XContentParser.Token token;
        if (this.parser.currentToken() != XContentParser.Token.START_OBJECT) {
            token = this.parser.nextToken();
            assert (token == XContentParser.Token.START_OBJECT);
        }
        token = this.parser.nextToken();
        assert (token == XContentParser.Token.FIELD_NAME);
        String queryName = this.parser.currentName();
        token = this.parser.nextToken();
        assert (token == XContentParser.Token.START_OBJECT || token == XContentParser.Token.START_ARRAY);
        XContentQueryParser queryParser = this.indexQueryParser.queryParser(queryName);
        if (queryParser == null) {
            throw new QueryParsingException(this.index, "No query registered for [" + queryName + "]");
        }
        Query result = queryParser.parse(this);
        if (this.parser.currentToken() == XContentParser.Token.END_OBJECT || this.parser.currentToken() == XContentParser.Token.END_ARRAY) {
            this.parser.nextToken();
        }
        return result;
    }

    public Filter parseInnerFilter() throws IOException, QueryParsingException {
        XContentParser.Token token;
        if (this.parser.currentToken() != XContentParser.Token.START_OBJECT) {
            token = this.parser.nextToken();
            assert (token == XContentParser.Token.START_OBJECT);
        }
        token = this.parser.nextToken();
        assert (token == XContentParser.Token.FIELD_NAME);
        String filterName = this.parser.currentName();
        token = this.parser.nextToken();
        assert (token == XContentParser.Token.START_OBJECT || token == XContentParser.Token.START_ARRAY);
        XContentFilterParser filterParser = this.indexQueryParser.filterParser(filterName);
        if (filterParser == null) {
            throw new QueryParsingException(this.index, "No filter registered for [" + filterName + "]");
        }
        Filter result = filterParser.parse(this);
        if (this.parser.currentToken() == XContentParser.Token.END_OBJECT || this.parser.currentToken() == XContentParser.Token.END_ARRAY) {
            this.parser.nextToken();
        }
        return result;
    }

    public FieldMapper fieldMapper(String name) {
        FieldMappers fieldMappers = this.indexQueryParser.mapperService.smartNameFieldMappers(name);
        if (fieldMappers == null) {
            return null;
        }
        return fieldMappers.mapper();
    }

    public String indexName(String name) {
        FieldMapper smartMapper = this.fieldMapper(name);
        if (smartMapper == null) {
            return name;
        }
        return smartMapper.names().indexName();
    }

    public MapperService.SmartNameFieldMappers smartFieldMappers(String name) {
        return this.indexQueryParser.mapperService.smartName(name);
    }
}

