/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.statistical;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.statistical.InternalStatisticalFacet;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptStatisticalFacetCollector
extends AbstractFacetCollector {
    private final SearchScript script;
    private double min = Double.MAX_VALUE;
    private double max = Double.MIN_VALUE;
    private double total = 0.0;
    private double sumOfSquares = 0.0;
    private long count;

    public ScriptStatisticalFacetCollector(String facetName, String scriptLang, String script, Map<String, Object> params, SearchContext context) {
        super(facetName);
        this.script = context.scriptService().search(context.lookup(), scriptLang, script, params);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.script.setNextDocId(doc);
        double value = this.script.runAsDouble();
        if (value < this.min) {
            this.min = value;
        }
        if (value > this.max) {
            this.max = value;
        }
        this.sumOfSquares += value * value;
        this.total += value;
        ++this.count;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.script.setScorer(scorer);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.script.setNextReader(reader);
    }

    @Override
    public Facet facet() {
        if (this.min == Double.MAX_VALUE) {
            this.min = Double.NaN;
        }
        if (this.max == Double.MIN_VALUE) {
            this.max = Double.NaN;
        }
        return new InternalStatisticalFacet(this.facetName, this.min, this.max, this.total, this.sumOfSquares, this.count);
    }
}

