/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab;

import org.apache.maven.model.Model;
import org.fusesource.fabric.fab.DependencyId;
import org.fusesource.fabric.fab.util.Strings;

public class VersionedDependencyId
extends DependencyId {
    private final String version;

    public VersionedDependencyId(String groupId, String artifactId, String version, String extension, String classifier) {
        super(groupId, artifactId, classifier, Strings.notEmpty(extension) ? extension : "jar");
        this.version = version;
    }

    public VersionedDependencyId(Model tree) {
        this(tree.getGroupId(), tree.getArtifactId(), tree.getVersion(), tree.getPackaging(), null);
    }

    public String getRepositoryPath() {
        return this.getGroupId().replace('.', '/') + "/" + this.getArtifactId() + "/" + this.getVersion() + "/" + this.getArtifactId() + "-" + this.getVersion() + (Strings.notEmpty(this.getClassifier()) ? "-" + this.getClassifier() : "") + "." + this.getExtension();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VersionedDependencyId)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VersionedDependencyId that = (VersionedDependencyId)o;
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public DependencyId toDependencyId() {
        return new DependencyId(this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getExtension());
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public String toString() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion() + ":" + this.getExtension() + (Strings.notEmpty(this.getClassifier()) ? ":" + this.getClassifier() : "");
    }

    public static VersionedDependencyId fromString(String value) {
        String[] parts = value.split(":");
        if (parts.length < 3) {
            throw new IllegalArgumentException("Invalid dependency id: " + value);
        }
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = parts[2];
        String extension = parts.length > 3 ? Strings.nullIfEmpty(parts[3]) : null;
        String classifier = parts.length > 4 ? Strings.nullIfEmpty(parts[4]) : null;
        return new VersionedDependencyId(groupId, artifactId, version, extension, classifier);
    }
}

